<?php
/**
 * Bulk Fix Store Categories
 * Process the selected stores from analyze_all_stores.php
 */

// Suppress deprecation warnings
error_reporting(E_ALL & ~E_DEPRECATED & ~E_NOTICE);
ini_set('display_errors', 1);

require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';

$connect = connect();
if (!$connect) die("Database connection failed");

echo "<style>
body { font-family: Arial, sans-serif; margin: 20px; }
.success { color: green; }
.error { color: red; }
.summary { background: #e8f5e9; padding: 15px; margin: 20px 0; border-left: 4px solid #4CAF50; }
.btn { padding: 10px 20px; margin: 10px 5px; cursor: pointer; background: #4CAF50; color: white; border: none; text-decoration: none; display: inline-block; }
</style>";

echo "<h1>Bulk Category Fix Results</h1>";

if (!isset($_POST['fix']) || empty($_POST['fix'])) {
    echo "<p class='error'>No stores selected for fixing.</p>";
    echo "<a href='analyze_all_stores.php' class='btn'>Go Back</a>";
    exit;
}

$fixes = $_POST['fix'];
$success_count = 0;
$error_count = 0;

echo "<h2>Processing " . count($fixes) . " stores...</h2>";

foreach ($fixes as $fix_data) {
    list($store_id, $category_id) = explode(':', $fix_data);
    $store_id = intval($store_id);
    $category_id = intval($category_id);
    
    // Get store name
    $store_query = $connect->prepare("SELECT store_title FROM stores WHERE store_id = :store_id");
    $store_query->execute([':store_id' => $store_id]);
    $store = $store_query->fetch(PDO::FETCH_ASSOC);
    
    if (!$store) {
        echo "<p class='error'>✗ Store ID $store_id not found</p>";
        $error_count++;
        continue;
    }
    
    try {
        // Update stores table
        $stmt = $connect->prepare("UPDATE stores SET store_category = :category WHERE store_id = :store_id");
        $stmt->execute([
            ':category' => $category_id,
            ':store_id' => $store_id
        ]);
        
        // Delete old category associations
        $delete_stmt = $connect->prepare("DELETE FROM store_categories WHERE store_id = :store_id");
        $delete_stmt->execute([':store_id' => $store_id]);
        
        // Insert new category association
        $insert_stmt = $connect->prepare("INSERT INTO store_categories (store_id, category_id) VALUES (:store_id, :category)");
        $insert_stmt->execute([
            ':store_id' => $store_id,
            ':category' => $category_id
        ]);
        
        echo "<p class='success'>✓ Fixed: {$store['store_title']} (ID: $store_id) → Category $category_id</p>";
        $success_count++;
        
    } catch (Exception $e) {
        echo "<p class='error'>✗ Error fixing {$store['store_title']}: " . $e->getMessage() . "</p>";
        $error_count++;
    }
}

echo "<div class='summary'>";
echo "<h2>Summary</h2>";
echo "<p><strong>Successfully fixed:</strong> $success_count stores</p>";
echo "<p><strong>Errors:</strong> $error_count</p>";

if ($error_count === 0) {
    echo "<p class='success'>✓ All selected stores have been fixed!</p>";
} else {
    echo "<p class='error'>⚠ Some errors occurred. Check the messages above.</p>";
}
echo "</div>";

echo "<a href='analyze_all_stores.php' class='btn'>Analyze Again</a>";
echo "<a href='verify_categories.php' class='btn'>Verify Results</a>";

?>
