    <nav class="tas_nav uk-navbar-container uk-section-white uk-visible@m">

        <div class="uk-navbar-left">
            <!-- Hamburger Menu Toggle -->
            <button class="uk-button uk-button-default hamburger-toggle" type="button" uk-toggle="target: #offcanvas-nav">
                <span uk-icon="icon: menu; ratio: 1.5"></span>
            </button>
            
            <a class="uk-navbar-item uk-logo" href="<?php echo $urlPath->home(); ?>">
                <img src="<?php echo $urlPath->image($theme['th_logo']); ?>" alt="<?php echo $translation['tr_1']; ?>">
            </a>
        </div>

        <div class="uk-width-expand search ajax-search-container">
        <form method="get" action="<?php echo $urlPath->search(); ?>">
            <div class="uk-inline uk-width-1-1">
                <span class="uk-form-icon uk-form-icon-flip btnSubmitForm"><i class="ti ti-search"></i></span>

                <?php if(!getSearchQuery() && empty(getSearchQuery())): ?>
                <input class="uk-input uk-width-1-1 uk-border-pill uk-form-large ajax-search-input animated-placeholder" name="query" placeholder="" autocomplete="off" data-placeholders='["Search Coupons...", "Search Offers...", "Search Stores..."]'>
                <?php endif; ?>

                <?php if(getSearchQuery() && !empty(getSearchQuery())): ?>
                <input class="uk-input uk-width-1-1 uk-border-pill uk-form-large ajax-search-input" name="query" value="<?php echo echoOutput(getSearchQuery()); ?>" placeholder="Search Coupons..." autocomplete="off">
                <?php endif; ?>

                <div class="ajax-search-results"></div>
            </div>
            </form>
        </div>

        <div class="uk-navbar-right">

        <?php if (isLogged()): ?>
            <?php if (!empty($userInfo) && isset($userInfo['user_name'])): ?>
            <div class="uk-grid-small uk-flex-middle" uk-grid>
                <div class="uk-width-auto">
                <div class="uk-cover-container uk-border-circle">
                    <img src="<?php echo $urlPath->image($userInfo['user_avatar']); ?>" alt="<?php echo echoOutput($userInfo['user_name']); ?>" uk-cover>
                    <canvas width="50" height="50"></canvas>
                </div>
                </div>
                <div class="uk-width-expand">
                    <h5 class="uk-margin-remove-bottom uk-text-bold"><?php echo echoOutput(textTruncate($userInfo['user_name'], 10)); ?></h5>
                    <p class="uk-comment-meta uk-margin-remove-top"><a href="<?php echo $urlPath->profile(); ?>" class="uk-link-muted"><?php echo $translation['tr_10']; ?></a></p>
                </div>
            </div>
            <?php endif; ?>
        <?php else: ?>

            <a href="<?php echo $urlPath->signin(); ?>" class="uk-button uk-button-primary uk-button-large uk-text-bold uk-border-pill button-header">
                <i class="fas fa-user-circle"></i> Login/Register
            </a>

        <?php endif; ?>

        </div>

    </nav>
<!-- END MAIN NAVBAR -->

<!-- Off-canvas Navigation Menu -->
<div id="offcanvas-nav" uk-offcanvas="overlay: true">
    <div class="uk-offcanvas-bar">
        <button class="uk-offcanvas-close" type="button" uk-close></button>
        
        <div class="uk-text-center uk-margin-bottom">
            <a href="<?php echo $urlPath->home(); ?>">
                <img src="<?php echo $urlPath->image($theme['th_logo']); ?>" alt="<?php echo $translation['tr_1']; ?>" style="max-width: 150px; height: auto;">
            </a>
        </div>
        
        <?php if (!isLogged()): ?>
        <div class="uk-margin-bottom">
            <a href="<?php echo $urlPath->signin(); ?>" class="uk-button uk-button-primary uk-width-1-1 uk-margin-small-bottom" style="background: #ed174f; border-color: #ed174f;">
                <span uk-icon="icon: sign-in; ratio: 0.9"></span>
                <span style="margin-left: 8px;">Login</span>
            </a>
            <a href="<?php echo $urlPath->signup(); ?>" class="uk-button uk-button-default uk-width-1-1">
                <span uk-icon="icon: user; ratio: 0.9"></span>
                <span style="margin-left: 8px;">Register</span>
            </a>
        </div>
        <?php endif; ?>
        
        <ul class="uk-nav uk-nav-default">
        <?php foreach($navigationHeader as $item): ?>
                 <?php if ($item['navigation_type'] == 'custom') { ?>
                    <?php if($item['navigation_url'] == '/'){ ?>
                    <li <?php if ($index_url == "index.php") echo ' class="uk-active"'; ?>><a href="<?php echo $urlPath->home(); ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
                    <?php }else{ ?>
                    <li <?php if ($current_url == $item['navigation_url']) echo ' class="uk-active"'; ?>><a href="<?php echo $item['navigation_url']; ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
                    <?php } ?>
                 <?php } else { ?>
                     <li <?php if ($current_url == $item['navigation_url']) echo ' class="uk-active"'; ?>><a href="<?php echo $urlPath->page($item['navigation_url']); ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
                 <?php } ?>
             <?php endforeach; ?>
        </ul>
        
        <?php if (count($menuCategories) > 0): ?>
        <h4 class="uk-margin-top uk-margin-small-bottom uk-text-bold uk-text-muted" style="font-size: 14px; text-transform: uppercase;">Categories</h4>
        <ul class="uk-nav uk-nav-default">
        <?php foreach($menuCategories as $category): ?>
        <li>
            <a href="<?php echo $urlPath->category($category['category_slug']); ?>">
                <div class="category-menu-image">
                    <img src="<?php echo getImageUrl($category['category_image_cdn_url'], $category['category_use_cdn'], $category['category_image']); ?>" alt="<?php echo htmlspecialchars($category['category_title']); ?>">
                </div>
                <span class="category-menu-title"><?php echo echoOutput($category['category_title']); ?></span>
            </a>
        </li>
        <?php endforeach; ?>
        </ul>
        <?php endif; ?>
    </div>
</div>

<?php require './sections/mobile-header.php'; ?>
