<?php
/**
 * SEO Setup Script
 * Run this once to set up SEO features
 */

require './core.php';
$connect = connect();

echo "<h1>SEO Setup Script</h1>";
echo "<hr>";

// 1. Generate initial sitemap
echo "<h3>1. Generating Sitemap...</h3>";
try {
    $sitemapUrl = SITE_URL . '/sitemap_auto.php';
    $sitemapContent = file_get_contents($sitemapUrl);
    
    if ($sitemapContent) {
        file_put_contents('sitemap.xml', $sitemapContent);
        echo "✅ Sitemap generated successfully!<br>";
        echo "📍 Location: <a href='" . SITE_URL . "/sitemap.xml' target='_blank'>" . SITE_URL . "/sitemap.xml</a><br>";
    } else {
        echo "❌ Failed to generate sitemap<br>";
    }
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "<br>";
}

echo "<br>";

// 2. Create/Update robots.txt
echo "<h3>2. Setting up robots.txt...</h3>";
$robotsContent = "# Robots.txt - Optimized for SEO
User-agent: *
Allow: /
Allow: /Post/
Allow: /author/
Allow: /store/
Allow: /category/

Disallow: /admin/
Disallow: /classes/
Disallow: /sections/

Allow: /*.css$
Allow: /*.js$

Sitemap: " . SITE_URL . "/sitemap.xml
Sitemap: " . SITE_URL . "/sitemap_auto.php

Crawl-delay: 1
";

if (file_put_contents('robots.txt', $robotsContent)) {
    echo "✅ robots.txt created successfully!<br>";
    echo "📍 Location: <a href='" . SITE_URL . "/robots.txt' target='_blank'>" . SITE_URL . "/robots.txt</a><br>";
} else {
    echo "❌ Failed to create robots.txt<br>";
}

echo "<br>";

// 3. Count URLs
echo "<h3>3. Sitemap Statistics...</h3>";
$totalPages = $connect->query("SELECT COUNT(*) FROM pages WHERE page_status = 1")->fetchColumn();
$totalPosts = $connect->query("SELECT COUNT(*) FROM blog_posts WHERE post_status = 'published'")->fetchColumn();
$totalStores = $connect->query("SELECT COUNT(*) FROM stores WHERE store_status = 1")->fetchColumn();
$totalCategories = $connect->query("SELECT COUNT(*) FROM categories WHERE category_status = 1")->fetchColumn();
$totalCoupons = $connect->query("SELECT COUNT(*) FROM coupons WHERE coupon_status = 1")->fetchColumn();
$totalUrls = $totalPages + $totalPosts + $totalStores + $totalCategories + $totalCoupons + 10;

echo "📊 Total URLs in sitemap: <strong>" . number_format($totalUrls) . "</strong><br>";
echo "📝 Blog Posts: " . number_format($totalPosts) . "<br>";
echo "🏪 Stores: " . number_format($totalStores) . "<br>";
echo "📁 Categories: " . number_format($totalCategories) . "<br>";
echo "🎟️ Coupons: " . number_format($totalCoupons) . "<br>";
echo "📄 Pages: " . number_format($totalPages) . "<br>";

echo "<br>";

// 4. Submit to search engines
echo "<h3>4. Submitting to Search Engines...</h3>";
$sitemapUrl = urlencode(SITE_URL . '/sitemap.xml');

// Google
try {
    $googleUrl = "https://www.google.com/ping?sitemap=" . $sitemapUrl;
    @file_get_contents($googleUrl);
    echo "✅ Submitted to Google<br>";
} catch (Exception $e) {
    echo "⚠️ Google submission: " . $e->getMessage() . "<br>";
}

// Bing
try {
    $bingUrl = "https://www.bing.com/ping?sitemap=" . $sitemapUrl;
    @file_get_contents($bingUrl);
    echo "✅ Submitted to Bing<br>";
} catch (Exception $e) {
    echo "⚠️ Bing submission: " . $e->getMessage() . "<br>";
}

echo "<br>";

// 5. Next steps
echo "<h3>5. Next Steps:</h3>";
echo "<ol>";
echo "<li>Verify your site in <a href='https://search.google.com/search-console' target='_blank'>Google Search Console</a></li>";
echo "<li>Submit sitemap in Search Console</li>";
echo "<li>Verify in <a href='https://www.bing.com/webmasters' target='_blank'>Bing Webmaster Tools</a></li>";
echo "<li>Access <a href='" . SITE_URL . "/admin/controller/seo_tools.php'>SEO Tools</a> in admin panel</li>";
echo "<li>Read the <a href='SEO_AUTOMATION_GUIDE.md' target='_blank'>SEO Automation Guide</a></li>";
echo "</ol>";

echo "<br>";
echo "<hr>";
echo "<p><strong>✅ SEO Setup Complete!</strong></p>";
echo "<p><a href='" . SITE_URL . "/admin/controller/seo_tools.php' class='btn btn-primary'>Go to SEO Tools</a></p>";

?>

<style>
body {
    font-family: Arial, sans-serif;
    max-width: 800px;
    margin: 50px auto;
    padding: 20px;
    background: #f5f5f5;
}
h1 {
    color: #333;
}
h3 {
    color: #666;
    margin-top: 20px;
}
.btn {
    display: inline-block;
    padding: 10px 20px;
    background: #007bff;
    color: white;
    text-decoration: none;
    border-radius: 5px;
    margin-top: 10px;
}
.btn:hover {
    background: #0056b3;
}
</style>
