<?php

require "core.php";

$slugItem = clearGetData(getSlugItem());

if(empty($slugItem) && !isset($slugItem)){

	header('Location: '. $urlPath->home());
}

// Get ID By Slug
$itemDetails = getCategoryBySlug($connect, $slugItem);

if(empty($itemDetails)){

	header('Location: '. $urlPath->home());
	
}

// Set ad display flags (enable ads for category pages)
$itemDetails['page_ad_header'] = 1;
$itemDetails['page_ad_footer'] = 1;
$itemDetails['page_footer'] = 1;

// Get sidebar data
$getCategories = getCategories($connect, 5);
$getStores = getStores($connect, 5);
$sidebarCampaigns = getSidebarCampaigns($connect, 2);

$getResults = getCouponsByCategory($connect, $site_config['page_limit'], $itemDetails['category_id']);

$items = $getResults['items'];
$total = $getResults['total'];

$numPages = numTotalPages($total, $site_config['page_limit']);

// Seo Title
$titleSeoHeader = getSeoTitle($itemDetails['category_title'] . ' Coupons & Deals');

// Seo Description
$descriptionSeoHeader = getSeoDescription('Browse all ' . $itemDetails['category_title'] . ' coupons and deals. Find the best discounts and promo codes.');

// Canonical URL
$canonicalUrl = SITE_URL . '/category/' . $itemDetails['category_slug'];

// Page Title
$pageTitle = $itemDetails['category_title'];

include './header.php';
include './sections/header.php';
include './sections/views/header-ad.view.php';

require './views/single-category.view.php';

include './sections/views/footer-ad.view.php';
include './sections/footer.php';
include './footer.php';

?>
