<?php
/**
 * Automatic Sitemap Generator with Blog Posts
 * Generates comprehensive sitemap including all content types
 * Can be run via cron job or manually
 */

header('Content-Type: application/xml; charset=utf-8');

require './core.php';
$connect = connect();

// Get settings
$settings = get_settings($connect);

echo '<?xml version="1.0" encoding="UTF-8"?>';
?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
        xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
        xmlns:news="http://www.google.com/schemas/sitemap-news/0.9">
    
    <!-- Homepage -->
    <url>
        <loc><?php echo SITE_URL; ?></loc>
        <lastmod><?php echo date('c'); ?></lastmod>
        <changefreq>daily</changefreq>
        <priority>1.0</priority>
    </url>
    
    <!-- Blog Homepage -->
    <url>
        <loc><?php echo SITE_URL; ?>/Post</loc>
        <lastmod><?php echo date('c'); ?></lastmod>
        <changefreq>daily</changefreq>
        <priority>0.95</priority>
    </url>
    
    <!-- Static Pages -->
    <?php
    $pages = $connect->query("SELECT page_slug, page_updated FROM pages WHERE page_status = 1 ORDER BY page_id DESC")->fetchAll();
    foreach ($pages as $page):
        $lastmod = $page['page_updated'] ? date('c', strtotime($page['page_updated'])) : date('c');
    ?>
    <url>
        <loc><?php echo SITE_URL . '/page/' . htmlspecialchars($page['page_slug']); ?></loc>
        <lastmod><?php echo $lastmod; ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.7</priority>
    </url>
    <?php endforeach; ?>
    
    <!-- Blog Posts (Published Only) -->
    <?php
    $posts = $connect->query("SELECT bp.post_slug, bp.post_title, bp.post_featured_image, bp.published_at, bp.updated_at, u.user_name 
                              FROM blog_posts bp 
                              LEFT JOIN users u ON bp.post_author = u.user_id 
                              WHERE bp.post_status = 'published' 
                              ORDER BY bp.published_at DESC")->fetchAll();
    foreach ($posts as $post):
        $lastmod = $post['updated_at'] ? date('c', strtotime($post['updated_at'])) : date('c', strtotime($post['published_at']));
        $publishDate = date('Y-m-d', strtotime($post['published_at']));
    ?>
    <url>
        <loc><?php echo SITE_URL . '/Post/' . htmlspecialchars($post['post_slug']); ?></loc>
        <lastmod><?php echo $lastmod; ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.9</priority>
        <?php if (!empty($post['post_featured_image'])): ?>
        <image:image>
            <image:loc><?php echo SITE_URL . '/images/' . htmlspecialchars($post['post_featured_image']); ?></image:loc>
            <image:title><?php echo htmlspecialchars($post['post_title']); ?></image:title>
        </image:image>
        <?php endif; ?>
        <?php if ((time() - strtotime($post['published_at'])) < 172800): // 48 hours ?>
        <news:news>
            <news:publication>
                <news:name><?php echo htmlspecialchars($settings['st_sitename']); ?></news:name>
                <news:language>en</news:language>
            </news:publication>
            <news:publication_date><?php echo date('c', strtotime($post['published_at'])); ?></news:publication_date>
            <news:title><?php echo htmlspecialchars($post['post_title']); ?></news:title>
        </news:news>
        <?php endif; ?>
    </url>
    <?php endforeach; ?>
    
    <!-- Blog Categories -->
    <?php
    $blogCategories = $connect->query("SELECT blog_cat_slug, blog_cat_name FROM blog_categories WHERE blog_cat_status = 1 ORDER BY blog_cat_id DESC")->fetchAll();
    foreach ($blogCategories as $cat):
    ?>
    <url>
        <loc><?php echo SITE_URL . '/Post?category=' . htmlspecialchars($cat['blog_cat_slug']); ?></loc>
        <lastmod><?php echo date('c'); ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
    <?php endforeach; ?>
    
    <!-- Author Pages -->
    <?php
    $authors = $connect->query("SELECT DISTINCT u.user_id, u.user_name FROM users u 
                                INNER JOIN blog_posts bp ON u.user_id = bp.post_author 
                                WHERE bp.post_status = 'published' AND u.user_status = 1")->fetchAll();
    foreach ($authors as $author):
    ?>
    <url>
        <loc><?php echo SITE_URL . '/author/' . $author['user_id']; ?></loc>
        <lastmod><?php echo date('c'); ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.75</priority>
    </url>
    <?php endforeach; ?>
    
    <!-- Stores -->
    <?php
    $stores = $connect->query("SELECT store_slug, store_image, store_title, store_updated FROM stores WHERE store_status = 1 ORDER BY store_id DESC LIMIT 2000")->fetchAll();
    foreach ($stores as $store):
        $lastmod = $store['store_updated'] ? date('c', strtotime($store['store_updated'])) : date('c');
    ?>
    <url>
        <loc><?php echo SITE_URL . '/store/' . htmlspecialchars($store['store_slug']); ?></loc>
        <lastmod><?php echo $lastmod; ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
        <?php if (!empty($store['store_image'])): ?>
        <image:image>
            <image:loc><?php echo SITE_URL . '/images/' . htmlspecialchars($store['store_image']); ?></image:loc>
            <image:title><?php echo htmlspecialchars($store['store_title']); ?></image:title>
        </image:image>
        <?php endif; ?>
    </url>
    <?php endforeach; ?>
    
    <!-- Categories -->
    <?php
    $categories = $connect->query("SELECT category_slug, category_image, category_title FROM categories WHERE category_status = 1 ORDER BY category_id DESC")->fetchAll();
    foreach ($categories as $category):
    ?>
    <url>
        <loc><?php echo SITE_URL . '/category/' . htmlspecialchars($category['category_slug']); ?></loc>
        <lastmod><?php echo date('c'); ?></lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.7</priority>
        <?php if (!empty($category['category_image'])): ?>
        <image:image>
            <image:loc><?php echo SITE_URL . '/images/' . htmlspecialchars($category['category_image']); ?></image:loc>
            <image:title><?php echo htmlspecialchars($category['category_title']); ?></image:title>
        </image:image>
        <?php endif; ?>
    </url>
    <?php endforeach; ?>
    
    <!-- Active Coupons (Limited to 1000 for performance) -->
    <?php
    $coupons = $connect->query("SELECT coupon_slug, coupon_updated FROM coupons WHERE coupon_status = 1 AND (coupon_expire IS NULL OR coupon_expire >= CURDATE()) ORDER BY coupon_id DESC LIMIT 1000")->fetchAll();
    foreach ($coupons as $coupon):
        $lastmod = $coupon['coupon_updated'] ? date('c', strtotime($coupon['coupon_updated'])) : date('c');
    ?>
    <url>
        <loc><?php echo SITE_URL . '/coupon/' . htmlspecialchars($coupon['coupon_slug']); ?></loc>
        <lastmod><?php echo $lastmod; ?></lastmod>
        <changefreq>monthly</changefreq>
        <priority>0.6</priority>
    </url>
    <?php endforeach; ?>
    
</urlset>
