<?php
require 'config.php';
require 'functions.php';

$connect = connect();

echo "<h2>Blog System Tables Check</h2>";

// Check blog_posts table
try {
    $result = $connect->query("SELECT COUNT(*) FROM blog_posts");
    echo "<p style='color:green;'>✓ blog_posts table exists (" . $result->fetchColumn() . " posts)</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>✗ blog_posts table missing</p>";
}

// Check blog_categories table
try {
    $result = $connect->query("SELECT COUNT(*) FROM blog_categories");
    echo "<p style='color:green;'>✓ blog_categories table exists (" . $result->fetchColumn() . " categories)</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>✗ blog_categories table missing</p>";
}

// Check blog_comments table
try {
    $result = $connect->query("SELECT COUNT(*) FROM blog_comments");
    echo "<p style='color:green;'>✓ blog_comments table exists (" . $result->fetchColumn() . " comments)</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>✗ blog_comments table missing</p>";
}

echo "<hr>";
echo "<h3>Solution:</h3>";
echo "<p>If any tables are missing, you need to run the SQL file:</p>";
echo "<ol>";
echo "<li>Open phpMyAdmin</li>";
echo "<li>Select your database: <strong>couponcmsi</strong></li>";
echo "<li>Go to SQL tab</li>";
echo "<li>Copy and paste contents of <strong>blog_system_setup.sql</strong></li>";
echo "<li>Click Execute</li>";
echo "</ol>";

echo "<p><a href='blog_system_setup.sql' target='_blank'>View blog_system_setup.sql</a></p>";
?>
