<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&family=Merriweather:ital,wght@0,400;0,700;1,400&display=swap" rel="stylesheet">

<!-- SEO: Preconnect to external domains for faster loading -->
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>

<style>
/* Modern Blog Reading Design */
:root {
    --primary-color: #6366f1;
    --primary-dark: #4f46e5;
    --secondary-color: #8b5cf6;
    --text-primary: #0f172a;
    --text-secondary: #475569;
    --text-light: #64748b;
    --bg-primary: #ffffff;
    --bg-secondary: #f8fafc;
    --bg-accent: #f1f5f9;
    --border-color: #e2e8f0;
    --success-color: #10b981;
    --shadow-sm: 0 1px 3px rgba(0,0,0,0.05);
    --shadow-md: 0 4px 12px rgba(0,0,0,0.08);
    --shadow-lg: 0 10px 30px rgba(0,0,0,0.12);
}

* {
    box-sizing: border-box;
}

body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
}

.blog-page {
    background: var(--bg-secondary);
    min-height: 100vh;
    padding: 50px 0;
}

.blog-max-width {
    max-width: 780px;
    margin: 0 auto;
    padding: 0 24px;
}

.blog-nav-back {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    color: var(--text-secondary);
    text-decoration: none;
    font-size: 14px;
    font-weight: 500;
    margin-bottom: 32px;
    transition: all 0.2s;
}

.blog-nav-back:hover {
    color: var(--primary-color);
    transform: translateX(-4px);
}

.blog-post-card {
    background: var(--bg-primary);
    border-radius: 12px;
    padding: 56px;
    box-shadow: var(--shadow-md);
    margin-bottom: 32px;
}

.post-header {
    margin-bottom: 48px;
}

.post-category {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: white;
    padding: 6px 16px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    margin-bottom: 20px;
}

.post-title {
    font-family: 'Inter', sans-serif;
    font-size: 44px;
    font-weight: 800;
    line-height: 1.2;
    color: var(--text-primary);
    margin: 0 0 28px 0;
    letter-spacing: -0.02em;
}

.post-meta-bar {
    display: flex;
    align-items: center;
    gap: 24px;
    padding-bottom: 28px;
    border-bottom: 2px solid var(--border-color);
    flex-wrap: wrap;
}

.post-author-link {
    display: flex;
    align-items: center;
    gap: 12px;
    text-decoration: none;
    transition: opacity 0.2s;
}

.post-author-link:hover {
    opacity: 0.8;
}

.author-img {
    width: 48px;
    height: 48px;
    border-radius: 50%;
    object-fit: cover;
    border: 2px solid var(--border-color);
}

.author-details {
    display: flex;
    flex-direction: column;
    gap: 2px;
}

.author-name {
    font-size: 15px;
    font-weight: 600;
    color: var(--text-primary);
}

.post-date {
    font-size: 13px;
    color: var(--text-light);
}

.post-views {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 13px;
    color: var(--text-light);
}

.post-reading-time {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 13px;
    color: var(--text-light);
}

.post-featured-img {
    width: 100%;
    height: auto;
    border-radius: 10px;
    margin: 40px 0;
    box-shadow: var(--shadow-md);
}

.post-content {
    font-family: 'Merriweather', Georgia, serif;
    font-size: 19px;
    line-height: 1.8;
    color: var(--text-secondary);
}

.post-content p {
    margin: 0 0 28px 0;
}

.post-content h1,
.post-content h2,
.post-content h3,
.post-content h4,
.post-content h5,
.post-content h6 {
    font-family: 'Inter', sans-serif;
    font-weight: 700;
    color: var(--text-primary);
    margin: 48px 0 24px 0;
    line-height: 1.3;
    letter-spacing: -0.01em;
}

.post-content h1 { font-size: 36px; }
.post-content h2 { font-size: 32px; }
.post-content h3 { font-size: 28px; }
.post-content h4 { font-size: 24px; }

.post-content img {
    max-width: 100%;
    height: auto;
    border-radius: 8px;
    margin: 36px 0;
    box-shadow: var(--shadow-sm);
}

.post-content blockquote {
    margin: 36px 0;
    padding: 24px 28px;
    border-left: 4px solid var(--primary-color);
    background: var(--bg-accent);
    border-radius: 0 8px 8px 0;
    font-style: italic;
    color: var(--text-secondary);
    font-size: 20px;
}

.post-content ul,
.post-content ol {
    margin: 24px 0;
    padding-left: 32px;
}

.post-content li {
    margin-bottom: 12px;
}

.post-content a {
    color: var(--primary-color);
    text-decoration: none;
    border-bottom: 1px solid rgba(99, 102, 241, 0.3);
    transition: all 0.2s;
}

.post-content a:hover {
    color: var(--primary-dark);
    border-bottom-color: var(--primary-dark);
}

.post-content code {
    background: var(--bg-accent);
    color: #e11d48;
    padding: 3px 8px;
    border-radius: 4px;
    font-size: 17px;
    font-family: 'Monaco', 'Courier New', monospace;
}

.post-content pre {
    background: #1e293b;
    color: #e2e8f0;
    padding: 24px;
    border-radius: 8px;
    overflow-x: auto;
    margin: 32px 0;
    box-shadow: var(--shadow-sm);
}

.post-content pre code {
    background: none;
    color: inherit;
    padding: 0;
}

.post-tags-section {
    margin: 48px 0;
    padding: 28px 0;
    border-top: 2px solid var(--border-color);
    border-bottom: 2px solid var(--border-color);
}

.tags-label {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    font-size: 14px;
    font-weight: 600;
    color: var(--text-secondary);
    margin-right: 12px;
}

.tag-badge {
    display: inline-block;
    padding: 8px 16px;
    background: var(--bg-accent);
    color: var(--text-secondary);
    font-size: 13px;
    font-weight: 500;
    border-radius: 6px;
    margin: 4px;
    transition: all 0.2s;
}

.tag-badge:hover {
    background: var(--primary-color);
    color: white;
}

.post-share-section {
    margin: 48px 0;
    text-align: center;
}

.share-title {
    font-size: 18px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 24px 0;
}

.share-btns {
    display: flex;
    justify-content: center;
    gap: 12px;
    flex-wrap: wrap;
}

.share-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 24px;
    border-radius: 8px;
    text-decoration: none;
    font-size: 14px;
    font-weight: 600;
    color: white;
    transition: all 0.3s;
    box-shadow: var(--shadow-sm);
}

.share-btn:hover {
    transform: translateY(-3px);
    box-shadow: var(--shadow-md);
}

.share-btn i {
    font-size: 16px;
}

.btn-facebook { background: #1877f2; }
.btn-twitter { background: #1da1f2; }
.btn-linkedin { background: #0a66c2; }
.btn-whatsapp { background: #25d366; }

.author-card {
    margin: 56px 0;
    padding: 40px;
    background: linear-gradient(135deg, #f8fafc 0%, #f1f5f9 100%);
    border-radius: 12px;
    border: 1px solid var(--border-color);
    display: flex;
    gap: 28px;
    align-items: flex-start;
}

.author-card-img {
    width: 88px;
    height: 88px;
    border-radius: 50%;
    object-fit: cover;
    flex-shrink: 0;
    border: 3px solid white;
    box-shadow: var(--shadow-sm);
}

.author-card-body {
    flex: 1;
}

.author-card-title {
    font-size: 20px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 12px 0;
}

.author-card-bio {
    font-size: 15px;
    line-height: 1.6;
    color: var(--text-secondary);
    margin: 0 0 16px 0;
}

.author-social-links {
    display: flex;
    gap: 10px;
}

.social-link {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: white;
    color: var(--text-secondary);
    text-decoration: none;
    transition: all 0.2s;
    box-shadow: var(--shadow-sm);
}

.social-link:hover {
    background: var(--primary-color);
    color: white;
    transform: translateY(-2px);
    box-shadow: var(--shadow-md);
}

.related-section {
    margin-top: 64px;
}

.related-title {
    font-size: 28px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 32px 0;
}

.related-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(240px, 1fr));
    gap: 24px;
}

.related-item {
    background: var(--bg-primary);
    border-radius: 10px;
    overflow: hidden;
    text-decoration: none;
    transition: all 0.3s;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--border-color);
}

.related-item:hover {
    transform: translateY(-6px);
    box-shadow: var(--shadow-lg);
    border-color: var(--primary-color);
}

.related-item img {
    width: 100%;
    height: 180px;
    object-fit: cover;
}

.related-item-body {
    padding: 20px;
}

.related-item-title {
    font-size: 16px;
    font-weight: 600;
    color: var(--text-primary);
    margin: 0 0 8px 0;
    line-height: 1.4;
}

.related-item-date {
    display: flex;
    align-items: center;
    gap: 6px;
    font-size: 13px;
    color: var(--text-light);
}

@media (max-width: 768px) {
    .blog-post-card {
        padding: 40px 28px;
    }
    
    .post-title {
        font-size: 32px;
    }
    
    .post-content {
        font-size: 18px;
    }
    
    .author-card {
        flex-direction: column;
        padding: 32px;
        text-align: center;
    }
    
    .author-social-links {
        justify-content: center;
    }
    
    .related-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 480px) {
    .blog-post-card {
        padding: 32px 20px;
    }
    
    .post-title {
        font-size: 28px;
    }
    
    .share-btns {
        flex-direction: column;
    }
    
    .share-btn {
        width: 100%;
        justify-content: center;
    }
}
</style>

<div class="blog-page">
    <div class="blog-max-width">
        <!-- Breadcrumb Navigation for SEO -->
        <nav aria-label="Breadcrumb" style="margin-bottom: 20px;">
            <ol style="display: flex; gap: 8px; list-style: none; padding: 0; font-size: 14px; color: var(--text-light);">
                <li><a href="<?php echo SITE_URL; ?>" style="color: var(--text-light); text-decoration: none;">Home</a></li>
                <li>/</li>
                <li><a href="<?php echo SITE_URL; ?>/Post" style="color: var(--text-light); text-decoration: none;">Blog</a></li>
                <?php if($post['blog_cat_name']): ?>
                <li>/</li>
                <li><a href="<?php echo SITE_URL; ?>/Post?category=<?php echo $post['blog_cat_slug']; ?>" style="color: var(--text-light); text-decoration: none;"><?php echo htmlspecialchars($post['blog_cat_name']); ?></a></li>
                <?php endif; ?>
                <li>/</li>
                <li aria-current="page" style="color: var(--text-secondary);"><?php echo htmlspecialchars($post['post_title']); ?></li>
            </ol>
        </nav>

        <a href="<?php echo SITE_URL; ?>/Post" class="blog-nav-back">
            <i class="fa fa-arrow-left"></i> Back to all posts
        </a>

        <article class="blog-post-card" itemscope itemtype="https://schema.org/Article">
            <header class="post-header">
                <?php if($post['blog_cat_name']): ?>
                <div class="post-category" itemprop="articleSection">
                    <i class="fa fa-folder-open"></i>
                    <?php echo htmlspecialchars($post['blog_cat_name']); ?>
                </div>
                <?php endif; ?>

                <h1 class="post-title" itemprop="headline"><?php echo htmlspecialchars($post['post_title']); ?></h1>

                <div class="post-meta-bar">
                    <a href="<?php echo SITE_URL; ?>/author/<?php echo $post['post_author']; ?>" class="post-author-link" itemprop="author" itemscope itemtype="https://schema.org/Person">
                        <img src="<?php echo SITE_URL; ?>/images/<?php echo $post['user_avatar'] ?? 'default-avatar.png'; ?>" 
                             alt="<?php echo htmlspecialchars($post['user_name'] ?: 'Admin'); ?>" 
                             class="author-img"
                             itemprop="image">
                        <div class="author-details">
                            <span class="author-name" itemprop="name"><?php echo htmlspecialchars($post['user_name'] ?: 'Admin'); ?></span>
                            <time class="post-date" datetime="<?php echo date('c', strtotime($post['created_at'])); ?>" itemprop="datePublished">
                                <?php echo date('F j, Y', strtotime($post['created_at'])); ?>
                            </time>
                        </div>
                    </a>
                    
                    <div class="post-views">
                        <i class="fa fa-eye"></i>
                        <span><?php echo number_format($post['post_views']); ?> views</span>
                    </div>
                    
                    <div class="post-reading-time">
                        <i class="fa fa-clock"></i>
                        <span><?php echo $post['reading_time']; ?> min read</span>
                    </div>
                </div>

                <!-- Hidden meta for SEO -->
                <meta itemprop="dateModified" content="<?php echo date('c', strtotime($post['updated_at'] ?: $post['created_at'])); ?>">
                <meta itemprop="mainEntityOfPage" content="<?php echo SITE_URL . '/Post/' . $post['post_slug']; ?>">
                <div itemprop="publisher" itemscope itemtype="https://schema.org/Organization" style="display: none;">
                    <meta itemprop="name" content="<?php echo htmlspecialchars($settings['st_sitename']); ?>">
                    <div itemprop="logo" itemscope itemtype="https://schema.org/ImageObject">
                        <meta itemprop="url" content="<?php echo SITE_URL; ?>/images/logo.png">
                    </div>
                </div>
            </header>

            <?php if($post['post_featured_image']): ?>
            <img src="<?php echo $post['post_use_cdn'] && $post['post_featured_image_cdn_url'] ? $post['post_featured_image_cdn_url'] : SITE_URL . '/images/' . $post['post_featured_image']; ?>" 
                 alt="<?php echo htmlspecialchars($post['post_title']); ?>"
                 class="post-featured-img"
                 itemprop="image">
            <?php endif; ?>

            <div class="post-content" itemprop="articleBody">
                <?php 
                if (!empty($post['post_content'])) {
                    echo $post['post_content']; 
                } else {
                    echo '<p style="color: #94a3b8;">Content not available.</p>';
                }
                ?>
            </div>

            <?php if($post['post_tags']): ?>
            <div class="post-tags-section" itemprop="keywords">
                <span class="tags-label">
                    <i class="fa fa-tags"></i> Tags
                </span>
                <?php 
                $tags = explode(',', $post['post_tags']);
                foreach($tags as $tag): 
                    $tag = trim($tag);
                ?>
                <span class="tag-badge"><?php echo htmlspecialchars($tag); ?></span>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>

            <div class="post-share-section">
                <h3 class="share-title">Share this article</h3>
                <div class="share-btns">
                    <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(SITE_URL . '/Post/' . $post['post_slug']); ?>" 
                       target="_blank" 
                       class="share-btn btn-facebook">
                        <i class="fa fa-facebook"></i> Facebook
                    </a>
                    <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode(SITE_URL . '/Post/' . $post['post_slug']); ?>&text=<?php echo urlencode($post['post_title']); ?>" 
                       target="_blank" 
                       class="share-btn btn-twitter">
                        <i class="fa fa-twitter"></i> Twitter
                    </a>
                    <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo urlencode(SITE_URL . '/Post/' . $post['post_slug']); ?>" 
                       target="_blank" 
                       class="share-btn btn-linkedin">
                        <i class="fa fa-linkedin"></i> LinkedIn
                    </a>
                    <a href="https://wa.me/?text=<?php echo urlencode($post['post_title'] . ' ' . SITE_URL . '/Post/' . $post['post_slug']); ?>" 
                       target="_blank" 
                       class="share-btn btn-whatsapp">
                        <i class="fa fa-whatsapp"></i> WhatsApp
                    </a>
                </div>
            </div>

            <?php if(!empty($post['user_bio']) || !empty($post['user_facebook']) || !empty($post['user_twitter']) || !empty($post['user_instagram']) || !empty($post['user_linkedin']) || !empty($post['user_website'])): ?>
            <div class="author-card">
                <img src="<?php echo SITE_URL; ?>/images/<?php echo $post['user_avatar'] ?? 'default-avatar.png'; ?>" 
                     alt="<?php echo htmlspecialchars($post['user_name'] ?: 'Admin'); ?>" 
                     class="author-card-img">
                <div class="author-card-body">
                    <h4 class="author-card-title">About <?php echo htmlspecialchars($post['user_name'] ?: 'Admin'); ?></h4>
                    <p class="author-card-bio"><?php echo nl2br(htmlspecialchars($post['user_bio'] ?: 'Content writer and editor.')); ?></p>
                    
                    <?php if(!empty($post['user_facebook']) || !empty($post['user_twitter']) || !empty($post['user_instagram']) || !empty($post['user_linkedin']) || !empty($post['user_website'])): ?>
                    <div class="author-social-links">
                        <?php if(!empty($post['user_facebook'])): ?>
                        <a href="<?php echo htmlspecialchars($post['user_facebook']); ?>" target="_blank" class="social-link" title="Facebook">
                            <i class="fa fa-facebook"></i>
                        </a>
                        <?php endif; ?>
                        <?php if(!empty($post['user_twitter'])): ?>
                        <a href="<?php echo htmlspecialchars($post['user_twitter']); ?>" target="_blank" class="social-link" title="Twitter">
                            <i class="fa fa-twitter"></i>
                        </a>
                        <?php endif; ?>
                        <?php if(!empty($post['user_instagram'])): ?>
                        <a href="<?php echo htmlspecialchars($post['user_instagram']); ?>" target="_blank" class="social-link" title="Instagram">
                            <i class="fa fa-instagram"></i>
                        </a>
                        <?php endif; ?>
                        <?php if(!empty($post['user_linkedin'])): ?>
                        <a href="<?php echo htmlspecialchars($post['user_linkedin']); ?>" target="_blank" class="social-link" title="LinkedIn">
                            <i class="fa fa-linkedin"></i>
                        </a>
                        <?php endif; ?>
                        <?php if(!empty($post['user_website'])): ?>
                        <a href="<?php echo htmlspecialchars($post['user_website']); ?>" target="_blank" class="social-link" title="Website">
                            <i class="fa fa-globe"></i>
                        </a>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php endif; ?>
        </article>

        <?php if(!empty($relatedPosts)): ?>
        <div class="related-section">
            <h3 class="related-title">Related Articles</h3>
            <div class="related-grid">
                <?php foreach($relatedPosts as $related): ?>
                <a href="<?php echo SITE_URL; ?>/Post/<?php echo $related['post_slug']; ?>" class="related-item">
                    <?php if($related['post_featured_image']): ?>
                    <img src="<?php echo getImageUrl($related['post_featured_image_cdn_url'], $related['post_use_cdn'], $related['post_featured_image']); ?>" 
                         alt="<?php echo htmlspecialchars($related['post_title']); ?>">
                    <?php endif; ?>
                    <div class="related-item-body">
                        <h4 class="related-item-title"><?php echo htmlspecialchars($related['post_title']); ?></h4>
                        <p class="related-item-date">
                            <i class="fa fa-calendar"></i>
                            <?php echo date('M j, Y', strtotime($related['created_at'])); ?>
                        </p>
                    </div>
                </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>
