<?php

session_start();

if (isset($_SESSION['user_email'])){

require '../../config.php';
require '../functions.php';

$connect = connect($database);

$check_access = check_access($connect);

if ($check_access['user_role'] == 1){

    // Get date range
    $start_date = isset($_GET['start_date']) ? $_GET['start_date'] : date('Y-m-d', strtotime('-30 days'));
    $end_date = isset($_GET['end_date']) ? $_GET['end_date'] : date('Y-m-d');
    
    // Get filter
    $filter_store = isset($_GET['store']) ? intval($_GET['store']) : 0;
    
    // Get overall statistics
    $total_clicks_query = "SELECT COUNT(*) as total FROM link_clicks WHERE DATE(clicked_at) BETWEEN :start AND :end";
    $unique_ips_query = "SELECT COUNT(DISTINCT ip_address) as total FROM link_clicks WHERE DATE(clicked_at) BETWEEN :start AND :end";
    
    if ($filter_store > 0) {
        $total_clicks_query .= " AND store_id = :store_id";
        $unique_ips_query .= " AND store_id = :store_id";
    }
    
    $stmt = $connect->prepare($total_clicks_query);
    $stmt->execute($filter_store > 0 ? [':start' => $start_date, ':end' => $end_date, ':store_id' => $filter_store] : [':start' => $start_date, ':end' => $end_date]);
    $total_clicks = $stmt->fetch()['total'];
    
    $stmt = $connect->prepare($unique_ips_query);
    $stmt->execute($filter_store > 0 ? [':start' => $start_date, ':end' => $end_date, ':store_id' => $filter_store] : [':start' => $start_date, ':end' => $end_date]);
    $unique_visitors = $stmt->fetch()['total'];
    
    // Get top stores by clicks
    $top_stores_query = "SELECT s.store_id, s.store_title, s.store_image, COUNT(lc.click_id) as click_count, COUNT(DISTINCT lc.ip_address) as unique_count
        FROM link_clicks lc
        JOIN stores s ON lc.store_id = s.store_id
        WHERE DATE(lc.clicked_at) BETWEEN :start AND :end";
    
    if ($filter_store > 0) {
        $top_stores_query .= " AND s.store_id = :store_id";
    }
    
    $top_stores_query .= " GROUP BY s.store_id ORDER BY click_count DESC LIMIT 20";
    
    $stmt = $connect->prepare($top_stores_query);
    $stmt->execute($filter_store > 0 ? [':start' => $start_date, ':end' => $end_date, ':store_id' => $filter_store] : [':start' => $start_date, ':end' => $end_date]);
    $top_stores = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get top coupons by clicks
    $top_coupons_query = "SELECT c.coupon_id, c.coupon_title, s.store_title, COUNT(lc.click_id) as click_count
        FROM link_clicks lc
        JOIN coupons c ON lc.coupon_id = c.coupon_id
        JOIN stores s ON c.coupon_store = s.store_id
        WHERE DATE(lc.clicked_at) BETWEEN :start AND :end";
    
    if ($filter_store > 0) {
        $top_coupons_query .= " AND s.store_id = :store_id";
    }
    
    $top_coupons_query .= " GROUP BY c.coupon_id ORDER BY click_count DESC LIMIT 20";
    
    $stmt = $connect->prepare($top_coupons_query);
    $stmt->execute($filter_store > 0 ? [':start' => $start_date, ':end' => $end_date, ':store_id' => $filter_store] : [':start' => $start_date, ':end' => $end_date]);
    $top_coupons = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get device statistics
    $device_stats = $connect->prepare("SELECT device_type, COUNT(*) as count FROM link_clicks WHERE DATE(clicked_at) BETWEEN :start AND :end GROUP BY device_type");
    $device_stats->execute([':start' => $start_date, ':end' => $end_date]);
    $device_data = $device_stats->fetchAll(PDO::FETCH_ASSOC);
    
    // Get browser statistics
    $browser_stats = $connect->prepare("SELECT browser, COUNT(*) as count FROM link_clicks WHERE DATE(clicked_at) BETWEEN :start AND :end GROUP BY browser ORDER BY count DESC LIMIT 10");
    $browser_stats->execute([':start' => $start_date, ':end' => $end_date]);
    $browser_data = $browser_stats->fetchAll(PDO::FETCH_ASSOC);
    
    // Get recent clicks
    $recent_clicks_query = "SELECT lc.*, s.store_title, c.coupon_title
        FROM link_clicks lc
        LEFT JOIN stores s ON lc.store_id = s.store_id
        LEFT JOIN coupons c ON lc.coupon_id = c.coupon_id
        WHERE DATE(lc.clicked_at) BETWEEN :start AND :end";
    
    if ($filter_store > 0) {
        $recent_clicks_query .= " AND lc.store_id = :store_id";
    }
    
    $recent_clicks_query .= " ORDER BY lc.clicked_at DESC LIMIT 50";
    
    $stmt = $connect->prepare($recent_clicks_query);
    $stmt->execute($filter_store > 0 ? [':start' => $start_date, ':end' => $end_date, ':store_id' => $filter_store] : [':start' => $start_date, ':end' => $end_date]);
    $recent_clicks = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get all stores for filter
    $all_stores = $connect->query("SELECT store_id, store_title FROM stores WHERE store_status = 1 ORDER BY store_title")->fetchAll(PDO::FETCH_ASSOC);
    
    // Get banned IPs count
    $banned_ips_count = $connect->query("SELECT COUNT(*) as total FROM banned_ips WHERE is_permanent = 1 OR expires_at > NOW()")->fetch()['total'];

    require '../views/header.view.php';
    require '../views/link_tracking.view.php';

}else{
    header('Location:'.SITE_URL);
}

require '../views/footer.view.php';

}else {
    header('Location: ./login.php');		
}

?>
