-- ============================================
-- UPDATE FOOTER PAGES WITH PROPER CONTENT
-- ============================================
-- This SQL updates existing pages and adds FAQ page
-- Run this in phpMyAdmin to update footer pages
-- ============================================

-- Update Terms and Conditions (Page ID: 1)
UPDATE `pages` SET 
    `page_title` = 'Terms and Conditions',
    `page_content` = '<div class="footer-page-content">
    <h1>Terms and Conditions</h1>
    <p class="last-updated">Last Updated: January 2, 2026</p>
    
    <section class="page-section">
        <h2>1. Acceptance of Terms</h2>
        <p>By accessing and using Alonedeals.com, you accept and agree to be bound by the terms and provision of this agreement. If you do not agree to these terms, please do not use our website.</p>
    </section>
    
    <section class="page-section">
        <h2>2. Use of Service</h2>
        <p>Alonedeals.com is a coupon and deals aggregation platform that provides users with access to promotional offers, discount codes, and affiliate product links from various online retailers.</p>
        <ul>
            <li>You must be at least 18 years old to use this service</li>
            <li>You are responsible for maintaining the confidentiality of your account</li>
            <li>You agree not to use the service for any unlawful purpose</li>
            <li>We reserve the right to refuse service to anyone for any reason at any time</li>
        </ul>
    </section>
    
    <section class="page-section">
        <h2>3. Affiliate Disclosure</h2>
        <p>Alonedeals.com participates in various affiliate marketing programs. This means we may earn a commission when you click on links and make purchases through our platform, at no additional cost to you. These commissions help us maintain and improve our service.</p>
    </section>
    
    <section class="page-section">
        <h2>4. Coupon and Deal Accuracy</h2>
        <p>While we strive to provide accurate and up-to-date information:</p>
        <ul>
            <li>We do not guarantee that all coupons and deals will work</li>
            <li>Offers may expire or change without notice</li>
            <li>Retailers have the final say on coupon validity and terms</li>
            <li>We are not responsible for any issues arising from the use of coupons or deals</li>
        </ul>
    </section>
    
    <section class="page-section">
        <h2>5. User Content</h2>
        <p>Users may submit coupons, reviews, and comments. By submitting content, you grant us a non-exclusive, royalty-free, perpetual license to use, modify, and display that content. We reserve the right to remove any content that violates our policies.</p>
    </section>
    
    <section class="page-section">
        <h2>6. Intellectual Property</h2>
        <p>All content on Alonedeals.com, including text, graphics, logos, and software, is the property of Alonedeals.com or its content suppliers and is protected by copyright laws. Unauthorized use is prohibited.</p>
    </section>
    
    <section class="page-section">
        <h2>7. Limitation of Liability</h2>
        <p>Alonedeals.com shall not be liable for any direct, indirect, incidental, special, or consequential damages resulting from:</p>
        <ul>
            <li>Use or inability to use our service</li>
            <li>Unauthorized access to your data</li>
            <li>Errors or omissions in content</li>
            <li>Any third-party conduct or content on the service</li>
        </ul>
    </section>
    
    <section class="page-section">
        <h2>8. External Links</h2>
        <p>Our website contains links to third-party websites. We are not responsible for the content, privacy policies, or practices of these external sites. Clicking on affiliate links is at your own risk.</p>
    </section>
    
    <section class="page-section">
        <h2>9. Modifications to Terms</h2>
        <p>We reserve the right to modify these terms at any time. Changes will be effective immediately upon posting. Your continued use of the service constitutes acceptance of the modified terms.</p>
    </section>
    
    <section class="page-section">
        <h2>10. Termination</h2>
        <p>We may terminate or suspend your account and access to the service immediately, without prior notice, for any breach of these Terms.</p>
    </section>
    
    <section class="page-section">
        <h2>11. Governing Law</h2>
        <p>These Terms shall be governed by and construed in accordance with the laws of India, without regard to its conflict of law provisions.</p>
    </section>
    
    <section class="page-section">
        <h2>12. Contact Information</h2>
        <p>If you have any questions about these Terms, please contact us through our Contact Us page.</p>
    </section>
</div>',
    `page_status` = 1,
    `page_footer` = 1,
    `page_slug` = 'terms-and-conditions',
    `page_seotitle` = 'Terms and Conditions | Alonedeals.com',
    `page_seodescription` = 'Read the Terms and Conditions for using Alonedeals.com. Learn about our policies, affiliate disclosure, and user agreements.'
WHERE `page_id` = 1;

-- Update Privacy Policy (Page ID: 5)
UPDATE `pages` SET 
    `page_title` = 'Privacy Policy',
    `page_content` = '<div class="footer-page-content">
    <h1>Privacy Policy</h1>
    <p class="last-updated">Last Updated: January 2, 2026</p>
    
    <section class="page-section">
        <h2>1. Introduction</h2>
        <p>At Alonedeals.com, we are committed to protecting your privacy. This Privacy Policy explains how we collect, use, disclose, and safeguard your information when you visit our website.</p>
    </section>
    
    <section class="page-section">
        <h2>2. Information We Collect</h2>
        <h3>Personal Information</h3>
        <p>We may collect personal information that you voluntarily provide to us when you:</p>
        <ul>
            <li>Register for an account</li>
            <li>Subscribe to our newsletter</li>
            <li>Submit coupons or deals</li>
            <li>Post comments or reviews</li>
            <li>Contact us via email or contact form</li>
        </ul>
        <p>This information may include: name, email address, username, and any other information you choose to provide.</p>
        
        <h3>Automatically Collected Information</h3>
        <p>When you visit our website, we automatically collect certain information about your device, including:</p>
        <ul>
            <li>IP address</li>
            <li>Browser type and version</li>
            <li>Operating system</li>
            <li>Referring URLs</li>
            <li>Pages viewed and time spent on pages</li>
            <li>Click data and navigation patterns</li>
        </ul>
    </section>
    
    <section class="page-section">
        <h2>3. How We Use Your Information</h2>
        <p>We use the information we collect to:</p>
        <ul>
            <li>Provide, operate, and maintain our website</li>
            <li>Improve and personalize your experience</li>
            <li>Send you newsletters and promotional emails (with your consent)</li>
            <li>Respond to your comments and questions</li>
            <li>Analyze usage patterns and trends</li>
            <li>Detect and prevent fraud or abuse</li>
            <li>Comply with legal obligations</li>
        </ul>
    </section>
    
    <section class="page-section">
        <h2>4. Cookies and Tracking Technologies</h2>
        <p>We use cookies and similar tracking technologies to track activity on our website and store certain information. Cookies are small data files stored on your device.</p>
        <h3>Types of Cookies We Use:</h3>
        <ul>
            <li><strong>Essential Cookies:</strong> Required for the website to function properly</li>
            <li><strong>Analytics Cookies:</strong> Help us understand how visitors use our site</li>
            <li><strong>Advertising Cookies:</strong> Used to deliver relevant ads and track campaign performance</li>
            <li><strong>Preference Cookies:</strong> Remember your settings and preferences</li>
        </ul>
        <p>You can control cookies through your browser settings. However, disabling cookies may affect website functionality.</p>
    </section>
    
    <section class="page-section">
        <h2>5. Third-Party Services</h2>
        <p>We work with third-party service providers who may collect information about you:</p>
        <ul>
            <li><strong>Analytics:</strong> Google Analytics to understand website usage</li>
            <li><strong>Advertising:</strong> Ad networks to display relevant advertisements</li>
            <li><strong>Affiliate Networks:</strong> To track purchases and earn commissions</li>
            <li><strong>Email Services:</strong> To send newsletters and notifications</li>
        </ul>
        <p>These third parties have their own privacy policies governing their use of your information.</p>
    </section>
    
    <section class="page-section">
        <h2>6. Affiliate Links and Commissions</h2>
        <p>Alonedeals.com participates in affiliate marketing programs. When you click on affiliate links and make purchases, we may earn a commission. This does not affect the price you pay. Affiliate partners may use cookies to track your activity.</p>
    </section>
    
    <section class="page-section">
        <h2>7. Data Security</h2>
        <p>We implement appropriate technical and organizational security measures to protect your personal information. However, no method of transmission over the Internet is 100% secure, and we cannot guarantee absolute security.</p>
    </section>
    
    <section class="page-section">
        <h2>8. Data Retention</h2>
        <p>We retain your personal information only for as long as necessary to fulfill the purposes outlined in this Privacy Policy, unless a longer retention period is required by law.</p>
    </section>
    
    <section class="page-section">
        <h2>9. Your Privacy Rights</h2>
        <p>Depending on your location, you may have the following rights:</p>
        <ul>
            <li>Access the personal information we hold about you</li>
            <li>Request correction of inaccurate information</li>
            <li>Request deletion of your personal information</li>
            <li>Object to processing of your personal information</li>
            <li>Request restriction of processing</li>
            <li>Data portability</li>
            <li>Withdraw consent at any time</li>
        </ul>
        <p>To exercise these rights, please contact us through our Contact Us page.</p>
    </section>
    
    <section class="page-section">
        <h2>10. Children\'s Privacy</h2>
        <p>Our service is not intended for children under 18 years of age. We do not knowingly collect personal information from children. If you believe we have collected information from a child, please contact us immediately.</p>
    </section>
    
    <section class="page-section">
        <h2>11. International Data Transfers</h2>
        <p>Your information may be transferred to and maintained on servers located outside of your country. By using our service, you consent to this transfer.</p>
    </section>
    
    <section class="page-section">
        <h2>12. Changes to This Privacy Policy</h2>
        <p>We may update this Privacy Policy from time to time. We will notify you of any changes by posting the new policy on this page and updating the "Last Updated" date.</p>
    </section>
    
    <section class="page-section">
        <h2>13. Contact Us</h2>
        <p>If you have any questions about this Privacy Policy, please contact us through our Contact Us page.</p>
    </section>
</div>',
    `page_status` = 1,
    `page_footer` = 1,
    `page_slug` = 'privacy-policy',
    `page_seotitle` = 'Privacy Policy | Alonedeals.com',
    `page_seodescription` = 'Learn how Alonedeals.com collects, uses, and protects your personal information. Read our comprehensive Privacy Policy.'
WHERE `page_id` = 5;

-- Update About Us (Page ID: 9) - Replace with properly styled content
UPDATE `pages` SET 
    `page_title` = 'About Us',
    `page_content` = '<div class="footer-page-content">
    <h1>About Us</h1>
    <p class="page-intro">Welcome to <strong>Alonedeals.com</strong> — your trusted destination for finding the best online coupons, deals, discounts, and affiliate product offers across India and worldwide. Our mission is simple: <strong>to help you save more on every purchase</strong>.</p>
    
    <section class="page-section">
        <h2>Who We Are</h2>
        <p>Alonedeals.com is an affiliate-based platform created for smart shoppers who want verified deals, exclusive offers, and the latest discounts from top online stores. Whether you\'re buying electronics, fashion, home appliances, beauty essentials, or travel bookings — we bring you the best savings from trusted brands.</p>
    </section>
    
    <section class="page-section">
        <h2>What We Do</h2>
        <p>We partner with leading e-commerce platforms and affiliate networks to curate:</p>
        <ul>
            <li>Latest deals and offers</li>
            <li>Verified coupon codes</li>
            <li>Exclusive discounts</li>
            <li>Top trending products</li>
            <li>Price drops and flash sales</li>
        </ul>
        <p>Our team constantly updates the website to ensure that our users get fresh and active deals every day.</p>
    </section>
    
    <section class="page-section">
        <h2>How We Operate (Affiliate Disclosure)</h2>
        <p>Alonedeals.com participates in various affiliate marketing programs. This means we may earn a small commission when you click on links and make purchases — <strong>at no extra cost to you</strong>. This helps us maintain the platform and continue providing high-quality deals and product recommendations.</p>
    </section>
    
    <section class="page-section">
        <h2>Why Choose Alonedeals.com?</h2>
        <div class="features-grid">
            <div class="feature-item">
                <h3>✓ 100% Verified Coupons</h3>
                <p>All coupons and deals are verified and tested to ensure they work when you need them.</p>
            </div>
            <div class="feature-item">
                <h3>✓ Handpicked Collections</h3>
                <p>User-friendly collections organized by category, store, and popularity for easy browsing.</p>
            </div>
            <div class="feature-item">
                <h3>✓ Trusted Partnerships</h3>
                <p>We partner only with reputable brands and affiliate networks you can trust.</p>
            </div>
            <div class="feature-item">
                <h3>✓ Daily Updates</h3>
                <p>Fresh deals added every day with expired offers removed promptly.</p>
            </div>
            <div class="feature-item">
                <h3>✓ Completely Free</h3>
                <p>No subscription fees, no hidden charges. Save money without spending any.</p>
            </div>
            <div class="feature-item">
                <h3>✓ Easy to Use</h3>
                <p>Simple interface designed for quick deal discovery and seamless shopping.</p>
            </div>
        </div>
    </section>
    
    <section class="page-section">
        <h2>Our Mission</h2>
        <p>To make online shopping more affordable for everyone by providing accurate, updated, and user-friendly deal information.</p>
    </section>
    
    <section class="page-section">
        <h2>Our Vision</h2>
        <p>To become one of the most trusted deal and coupon websites in India by helping millions save money every day.</p>
    </section>
    
    <section class="page-section">
        <h2>Our Values</h2>
        <div class="values-list">
            <div class="value-item">
                <h3>Transparency</h3>
                <p>We clearly disclose our affiliate relationships and how we earn commissions.</p>
            </div>
            <div class="value-item">
                <h3>Trust</h3>
                <p>We verify every deal and remove expired offers to maintain user trust.</p>
            </div>
            <div class="value-item">
                <h3>Quality</h3>
                <p>We curate only the best deals from reputable brands and retailers.</p>
            </div>
            <div class="value-item">
                <h3>Community</h3>
                <p>We value our users and encourage them to share deals and feedback.</p>
            </div>
        </div>
    </section>
    
    <section class="page-section">
        <h2>Get in Touch</h2>
        <p>If you have questions, feedback, or partnership inquiries, feel free to contact us via our Contact Us page.</p>
        <p>Thank you for choosing <strong>Alonedeals.com</strong>. Happy Savings!</p>
    </section>
</div>',
    `page_status` = 1,
    `page_footer` = 1,
    `page_template` = 'blank',
    `page_slug` = 'about-us',
    `page_seotitle` = 'About Us | Alonedeals.com - Your Trusted Deals Platform',
    `page_seodescription` = 'Learn about Alonedeals.com - your trusted destination for finding the best online coupons, deals, and discounts across India and worldwide.'
WHERE `page_id` = 9;

-- Insert or Update FAQ Page
INSERT INTO `pages` (`page_title`, `page_content`, `page_status`, `page_private`, `page_footer`, `page_ad_header`, `page_ad_footer`, `page_ad_sidebar`, `page_template`, `page_slug`, `page_seotitle`, `page_seodescription`) VALUES
('Frequently Asked Questions', '<div class="footer-page-content">
    <h1>Frequently Asked Questions (FAQ)</h1>
    <p class="page-intro">Find answers to common questions about Alonedeals.com, coupons, deals, and how our platform works.</p>
    
    <section class="page-section faq-section">
        <h2>General Questions</h2>
        
        <div class="faq-item">
            <h3>What is Alonedeals.com?</h3>
            <p>Alonedeals.com is a free coupon and deals aggregation platform that helps you save money on online shopping. We provide verified coupon codes, exclusive deals, discounts, and affiliate product offers from top online retailers across India and worldwide.</p>
        </div>
        
        <div class="faq-item">
            <h3>Is Alonedeals.com free to use?</h3>
            <p>Yes! Alonedeals.com is completely free for all users. You can browse coupons, deals, and products without any subscription or registration fees.</p>
        </div>
        
        <div class="faq-item">
            <h3>Do I need to create an account?</h3>
            <p>No, you can browse and use coupons without creating an account. However, creating a free account allows you to save favorite deals, submit coupons, and receive personalized deal alerts.</p>
        </div>
    </section>
    
    <section class="page-section faq-section">
        <h2>About Coupons & Deals</h2>
        
        <div class="faq-item">
            <h3>How do I use a coupon code?</h3>
            <p>Simply click on the "Get Code" button next to any coupon. The code will be revealed and automatically copied to your clipboard. Then, visit the retailer\'s website and paste the code at checkout to apply the discount.</p>
        </div>
        
        <div class="faq-item">
            <h3>Why didn\'t my coupon work?</h3>
            <p>Coupons may not work for several reasons:</p>
            <ul>
                <li>The coupon has expired</li>
                <li>The coupon has usage limits that have been reached</li>
                <li>The items in your cart don\'t meet the coupon requirements (minimum purchase, specific categories, etc.)</li>
                <li>The coupon is only valid for new customers or specific regions</li>
            </ul>
            <p>If a coupon doesn\'t work, please report it so we can update or remove it.</p>
        </div>
        
        <div class="faq-item">
            <h3>How often are coupons updated?</h3>
            <p>Our team updates coupons and deals daily. We verify new offers and remove expired ones to ensure you get the most current and working deals.</p>
        </div>
        
        <div class="faq-item">
            <h3>Can I submit my own coupons?</h3>
            <p>Yes! If you find a great deal or coupon code, you can submit it through our "Submit Coupon" feature. After verification, we\'ll add it to our database and credit you as the contributor.</p>
        </div>
    </section>
    
    <section class="page-section faq-section">
        <h2>Affiliate & Earnings</h2>
        
        <div class="faq-item">
            <h3>What does "affiliate link" mean?</h3>
            <p>An affiliate link is a special tracking link that allows us to earn a small commission when you make a purchase through our platform. This commission comes from the retailer, not from you, so it doesn\'t affect the price you pay.</p>
        </div>
        
        <div class="faq-item">
            <h3>Do affiliate links cost me extra money?</h3>
            <p>No! Affiliate commissions are paid by the retailer, not by you. You pay the same price (or less with our coupons) whether you use our link or go directly to the store.</p>
        </div>
        
        <div class="faq-item">
            <h3>How does Alonedeals.com make money?</h3>
            <p>We earn commissions through affiliate partnerships when users make purchases through our links. We may also display advertisements. These revenue streams help us maintain the platform and continue providing free deals to users.</p>
        </div>
    </section>
    
    <section class="page-section faq-section">
        <h2>Account & Privacy</h2>
        
        <div class="faq-item">
            <h3>Is my personal information safe?</h3>
            <p>Yes. We take privacy seriously and implement security measures to protect your data. We only collect necessary information and never sell your personal data to third parties. Read our <a href="/privacy-policy">Privacy Policy</a> for details.</p>
        </div>
        
        <div class="faq-item">
            <h3>How do I unsubscribe from emails?</h3>
            <p>Every email we send includes an "Unsubscribe" link at the bottom. Click it to stop receiving promotional emails. You can also manage your email preferences in your account settings.</p>
        </div>
        
        <div class="faq-item">
            <h3>How do I delete my account?</h3>
            <p>To delete your account, please contact us through our Contact Us page with your request. We\'ll process your deletion within 7 business days.</p>
        </div>
    </section>
    
    <section class="page-section faq-section">
        <h2>Technical Issues</h2>
        
        <div class="faq-item">
            <h3>The website isn\'t loading properly. What should I do?</h3>
            <p>Try these troubleshooting steps:</p>
            <ul>
                <li>Clear your browser cache and cookies</li>
                <li>Try a different browser</li>
                <li>Disable browser extensions temporarily</li>
                <li>Check your internet connection</li>
            </ul>
            <p>If the problem persists, please contact us with details about your browser and device.</p>
        </div>
        
        <div class="faq-item">
            <h3>Can I use Alonedeals.com on mobile?</h3>
            <p>Yes! Our website is fully responsive and works on all mobile devices, tablets, and desktops. We don\'t currently have a mobile app, but our mobile website provides a great experience.</p>
        </div>
    </section>
    
    <section class="page-section faq-section">
        <h2>Store & Product Questions</h2>
        
        <div class="faq-item">
            <h3>How do I find deals for a specific store?</h3>
            <p>Use our search bar at the top of the page or browse our "Stores" section to find all deals and coupons for your favorite retailers.</p>
        </div>
        
        <div class="faq-item">
            <h3>Can I request deals for a specific store?</h3>
            <p>Yes! Contact us with your store request, and we\'ll do our best to add it to our platform if they have an affiliate program.</p>
        </div>
        
        <div class="faq-item">
            <h3>Are the products on your site sold by Alonedeals.com?</h3>
            <p>No. We don\'t sell products directly. When you click "Get Deal" on a product, you\'re redirected to the retailer\'s website where you can complete your purchase. We simply showcase deals and products from various online stores.</p>
        </div>
    </section>
    
    <section class="page-section faq-section">
        <h2>Still Have Questions?</h2>
        <p>If you couldn\'t find the answer you were looking for, please don\'t hesitate to contact us through our <a href="/contact-us">Contact Us</a> page. Our team is here to help!</p>
    </section>
</div>', 1, 0, 1, 0, 0, 0, 'blank', 'faq', 'FAQ - Frequently Asked Questions | Alonedeals.com', 'Find answers to common questions about Alonedeals.com, how to use coupons, affiliate links, account management, and more.')
ON DUPLICATE KEY UPDATE
    `page_title` = VALUES(`page_title`),
    `page_content` = VALUES(`page_content`),
    `page_status` = VALUES(`page_status`),
    `page_footer` = VALUES(`page_footer`),
    `page_template` = VALUES(`page_template`),
    `page_seotitle` = VALUES(`page_seotitle`),
    `page_seodescription` = VALUES(`page_seodescription`);

-- ============================================
-- EXECUTION COMPLETE
-- ============================================
-- Pages Updated:
-- 1. Terms and Conditions (ID: 1) - Updated with comprehensive terms
-- 2. Privacy Policy (ID: 5) - Updated with detailed privacy information
-- 3. About Us (ID: 9) - Template updated, content preserved
-- 4. FAQ (New) - Inserted with comprehensive Q&A
-- ============================================
