<?php require 'sidebar.php'; ?>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <h5><i class="fa fa-folder"></i> Blog Categories</h5>
        </div>

        <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo $_SESSION['success']; unset($_SESSION['success']); ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php endif; ?>

        <div class="row">

          <!-- Add/Edit Form -->
          <div class="col-md-4">
            <div class="block mb-4">
              <h6><?php echo $editCategory ? 'Edit Category' : 'Add New Category'; ?></h6>
              
              <form method="POST">
                <input type="hidden" name="action" value="<?php echo $editCategory ? 'edit' : 'add'; ?>">
                <?php if($editCategory): ?>
                <input type="hidden" name="blog_cat_id" value="<?php echo $editCategory['blog_cat_id']; ?>">
                <?php endif; ?>
                
                <div class="form-group">
                  <label class="required">Category Name</label>
                  <input type="text" name="blog_cat_name" class="form-control" 
                         value="<?php echo $editCategory ? htmlspecialchars($editCategory['blog_cat_name']) : ''; ?>" 
                         placeholder="e.g., Tech News" required>
                </div>
                
                <div class="form-group">
                  <label>Slug</label>
                  <input type="text" name="blog_cat_slug" class="form-control" 
                         value="<?php echo $editCategory ? htmlspecialchars($editCategory['blog_cat_slug']) : ''; ?>" 
                         placeholder="auto-generated">
                  <small class="form-text text-muted">Leave empty to auto-generate</small>
                </div>
                
                <div class="form-group">
                  <label>Description</label>
                  <textarea name="blog_cat_description" class="form-control" rows="3" 
                            placeholder="Brief description..."><?php echo $editCategory ? htmlspecialchars($editCategory['blog_cat_description']) : ''; ?></textarea>
                </div>
                
                <?php if($editCategory): ?>
                <div class="form-group">
                  <label>Status</label>
                  <select name="blog_cat_status" class="custom-select form-control">
                    <option value="1" <?php echo ($editCategory['blog_cat_status'] == 1) ? 'selected' : ''; ?>>Active</option>
                    <option value="0" <?php echo ($editCategory['blog_cat_status'] == 0) ? 'selected' : ''; ?>>Inactive</option>
                  </select>
                </div>
                <?php endif; ?>
                
                <button type="submit" class="btn btn-primary">
                  <i class="fa fa-save"></i> <?php echo $editCategory ? 'Update' : 'Add'; ?> Category
                </button>
                
                <?php if($editCategory): ?>
                <a href="./blog_categories.php" class="btn btn-secondary">Cancel</a>
                <?php endif; ?>
              </form>
            </div>
          </div>

          <!-- Categories List -->
          <div class="col-md-8">
            <div class="block mb-4">
              <h6>All Categories</h6>
              
              <div class="table-responsive">
                <table class="table table-striped table-bordered">
                  <thead>
                    <tr>
                      <th width="5%">ID</th>
                      <th>Name</th>
                      <th>Slug</th>
                      <th width="10%" class="text-center">Posts</th>
                      <th width="10%" class="text-center">Status</th>
                      <th width="15%" class="text-center">Actions</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php if(empty($categories)): ?>
                    <tr>
                      <td colspan="6" class="text-center text-muted">No categories found</td>
                    </tr>
                    <?php else: ?>
                    <?php foreach($categories as $cat): ?>
                    <tr>
                      <td><?php echo $cat['blog_cat_id']; ?></td>
                      <td>
                        <strong><?php echo htmlspecialchars($cat['blog_cat_name']); ?></strong>
                        <?php if($cat['blog_cat_description']): ?>
                        <br><small class="text-muted"><?php echo htmlspecialchars($cat['blog_cat_description']); ?></small>
                        <?php endif; ?>
                      </td>
                      <td><code><?php echo htmlspecialchars($cat['blog_cat_slug']); ?></code></td>
                      <td class="text-center"><?php echo $cat['post_count']; ?></td>
                      <td class="text-center">
                        <?php if($cat['blog_cat_status'] == 1): ?>
                        <span class="badge badge-pill bg-success">Active</span>
                        <?php else: ?>
                        <span class="badge badge-pill bg-secondary">Inactive</span>
                        <?php endif; ?>
                      </td>
                      <td class="text-center">
                        <a href="?edit=<?php echo $cat['blog_cat_id']; ?>" class="btn btn-small btn-primary" title="Edit">
                          <i class="fa fa-edit"></i>
                        </a>
                        <a href="?delete=<?php echo $cat['blog_cat_id']; ?>" class="btn btn-small btn-danger" 
                           onclick="return confirm('Delete this category? Posts will not be deleted.')" title="Delete">
                          <i class="fa fa-trash"></i>
                        </a>
                      </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php endif; ?>
                  </tbody>
                </table>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>
