<?php require 'sidebar.php'; ?>

<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        
        <div class="section-title">
          <h5>Edit Popup</h5>
        </div>

        <div class="row">
          <div class="col-lg-8">
            <div class="card">
              <div class="card-body">
                
                <?php if(!empty($errors)): ?>
                <div class="alert alert-danger">
                  <ul class="mb-0">
                    <?php foreach($errors as $error): ?>
                    <li><?php echo $error; ?></li>
                    <?php endforeach; ?>
                  </ul>
                </div>
                <?php endif; ?>

                <form method="post" enctype="multipart/form-data">
                  
                  <div class="form-group">
                    <label>Popup Title *</label>
                    <input type="text" name="popup_title" class="form-control" 
                           value="<?php echo htmlspecialchars($popup['popup_title']); ?>" required>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Popup Type *</label>
                        <select name="popup_type" class="form-control" required>
                          <option value="offer" <?php echo $popup['popup_type'] == 'offer' ? 'selected' : ''; ?>>Offer Popup</option>
                          <option value="newsletter" <?php echo $popup['popup_type'] == 'newsletter' ? 'selected' : ''; ?>>Newsletter Popup</option>
                          <option value="footer" <?php echo $popup['popup_type'] == 'footer' ? 'selected' : ''; ?>>Footer Popup</option>
                          <option value="custom" <?php echo $popup['popup_type'] == 'custom' ? 'selected' : ''; ?>>Custom Popup</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Position</label>
                        <select name="popup_position" class="form-control">
                          <option value="center" <?php echo $popup['popup_position'] == 'center' ? 'selected' : ''; ?>>Center</option>
                          <option value="bottom-right" <?php echo $popup['popup_position'] == 'bottom-right' ? 'selected' : ''; ?>>Bottom Right</option>
                          <option value="bottom-left" <?php echo $popup['popup_position'] == 'bottom-left' ? 'selected' : ''; ?>>Bottom Left</option>
                          <option value="top-right" <?php echo $popup['popup_position'] == 'top-right' ? 'selected' : ''; ?>>Top Right</option>
                          <option value="top-left" <?php echo $popup['popup_position'] == 'top-left' ? 'selected' : ''; ?>>Top Left</option>
                        </select>
                      </div>
                    </div>
                  </div>

                  <div class="form-group">
                    <label>Popup Content</label>
                    <textarea name="popup_content" class="form-control" rows="5" 
                              placeholder="HTML content for the popup"><?php echo htmlspecialchars($popup['popup_content']); ?></textarea>
                    <small class="text-muted">You can use HTML tags</small>
                  </div>

                  <div class="form-group">
                    <label>Popup Image</label>
                    <?php if($popup['popup_image']): ?>
                    <div class="mb-2">
                      <img src="../../images/<?php echo $popup['popup_image']; ?>" 
                           style="max-width: 200px; max-height: 150px; border-radius: 8px;">
                      <div class="mt-2">
                        <label>
                          <input type="checkbox" name="remove_image" value="1">
                          Remove current image
                        </label>
                      </div>
                    </div>
                    <?php endif; ?>
                    <input type="file" name="popup_image" class="form-control" accept="image/*">
                    <small class="text-muted">Upload new image to replace current one</small>
                  </div>

                  <!-- CDN Image Settings -->
                  <div class="form-group">
                    <fieldset style="border: 1px solid #ddd; padding: 15px; border-radius: 8px; background: #f8f9fa;">
                      <legend style="font-size: 14px; font-weight: bold; color: #007bff;">
                        <i class="fa fa-cloud"></i> CDN Image Settings
                      </legend>
                      
                      <div class="form-group">
                        <label>CDN Image URL</label>
                        <input type="url" name="popup_image_cdn_url" class="form-control" 
                               value="<?php echo isset($popup['popup_image_cdn_url']) ? htmlspecialchars($popup['popup_image_cdn_url']) : ''; ?>" 
                               placeholder="https://cdn.example.com/popups/popup-image.jpg">
                        <small class="form-text text-muted">
                          <i class="fa fa-info-circle"></i> Enter the CDN URL for this popup image
                        </small>
                      </div>
                      
                      <div class="form-group mb-0">
                        <div class="custom-control custom-switch">
                          <input type="checkbox" class="custom-control-input" id="popup_use_cdn" name="popup_use_cdn" 
                                 <?php echo (isset($popup['popup_use_cdn']) && $popup['popup_use_cdn'] == 1) ? 'checked' : ''; ?>>
                          <label class="custom-control-label" for="popup_use_cdn">
                            <strong>Use CDN Image</strong>
                          </label>
                        </div>
                        <small class="form-text text-muted">
                          When enabled, the CDN URL will be used instead of the local image
                        </small>
                      </div>
                    </fieldset>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Button Text</label>
                        <input type="text" name="popup_button_text" class="form-control" 
                               value="<?php echo htmlspecialchars($popup['popup_button_text']); ?>" 
                               placeholder="Get Offer">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Button Link</label>
                        <input type="text" name="popup_button_link" class="form-control" 
                               value="<?php echo htmlspecialchars($popup['popup_button_link']); ?>" 
                               placeholder="/stores">
                      </div>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Delay (milliseconds)</label>
                        <input type="number" name="popup_delay" class="form-control" 
                               value="<?php echo $popup['popup_delay']; ?>" min="0">
                        <small class="text-muted">0 = immediate</small>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Frequency</label>
                        <select name="popup_frequency" class="form-control">
                          <option value="once" <?php echo $popup['popup_frequency'] == 'once' ? 'selected' : ''; ?>>Once per user</option>
                          <option value="daily" <?php echo $popup['popup_frequency'] == 'daily' ? 'selected' : ''; ?>>Once per day</option>
                          <option value="session" <?php echo $popup['popup_frequency'] == 'session' ? 'selected' : ''; ?>>Once per session</option>
                          <option value="always" <?php echo $popup['popup_frequency'] == 'always' ? 'selected' : ''; ?>>Every page load</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Width</label>
                        <input type="text" name="popup_width" class="form-control" 
                               value="<?php echo htmlspecialchars($popup['popup_width']); ?>" 
                               placeholder="600px">
                      </div>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Show on Pages</label>
                        <select name="popup_show_on_pages" class="form-control">
                          <option value="all" <?php echo $popup['popup_show_on_pages'] == 'all' ? 'selected' : ''; ?>>All Pages</option>
                          <option value="home" <?php echo $popup['popup_show_on_pages'] == 'home' ? 'selected' : ''; ?>>Home Page Only</option>
                          <option value="stores" <?php echo $popup['popup_show_on_pages'] == 'stores' ? 'selected' : ''; ?>>Stores Page Only</option>
                          <option value="coupons" <?php echo $popup['popup_show_on_pages'] == 'coupons' ? 'selected' : ''; ?>>Coupons Page Only</option>
                          <option value="single" <?php echo $popup['popup_show_on_pages'] == 'single' ? 'selected' : ''; ?>>Single Pages Only</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Device Targeting</label>
                        <select name="popup_device" class="form-control">
                          <option value="both" <?php echo (!isset($popup['popup_device']) || $popup['popup_device'] == 'both') ? 'selected' : ''; ?>>Both (Mobile & Desktop)</option>
                          <option value="mobile" <?php echo (isset($popup['popup_device']) && $popup['popup_device'] == 'mobile') ? 'selected' : ''; ?>>Mobile Only</option>
                          <option value="desktop" <?php echo (isset($popup['popup_device']) && $popup['popup_device'] == 'desktop') ? 'selected' : ''; ?>>Desktop Only</option>
                        </select>
                        <small class="text-muted">Choose which devices should see this popup</small>
                      </div>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Start Date (Optional)</label>
                        <input type="datetime-local" name="popup_start_date" class="form-control"
                               value="<?php echo $popup['popup_start_date'] ? date('Y-m-d\TH:i', strtotime($popup['popup_start_date'])) : ''; ?>">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>End Date (Optional)</label>
                        <input type="datetime-local" name="popup_end_date" class="form-control"
                               value="<?php echo $popup['popup_end_date'] ? date('Y-m-d\TH:i', strtotime($popup['popup_end_date'])) : ''; ?>">
                      </div>
                    </div>
                  </div>

                  <div class="form-group">
                    <label>Priority (Higher = Shows First)</label>
                    <input type="number" name="popup_priority" class="form-control" 
                           value="<?php echo $popup['popup_priority']; ?>" min="0">
                  </div>

                  <div class="form-group">
                    <div class="custom-control custom-checkbox">
                      <input type="checkbox" class="custom-control-input" 
                             id="popup_enabled" name="popup_enabled" 
                             <?php echo $popup['popup_enabled'] ? 'checked' : ''; ?>>
                      <label class="custom-control-label" for="popup_enabled">
                        Enable this popup
                      </label>
                    </div>
                  </div>

                  <div class="form-group">
                    <button type="submit" class="btn btn-primary">
                      <i class="fa fa-save"></i> Update Popup
                    </button>
                    <a href="./popups.php" class="btn btn-secondary">Cancel</a>
                  </div>

                </form>

              </div>
            </div>
          </div>

          <div class="col-lg-4">
            <div class="card">
              <div class="card-header">
                <h6>Popup Statistics</h6>
              </div>
              <div class="card-body">
                <?php
                $views = $connect->query("SELECT COUNT(*) FROM popup_views WHERE popup_id = {$popup['popup_id']}")->fetchColumn();
                $clicks = $connect->query("SELECT COUNT(*) FROM popup_clicks WHERE popup_id = {$popup['popup_id']}")->fetchColumn();
                $ctr = $views > 0 ? round(($clicks / $views) * 100, 2) : 0;
                ?>
                <p><strong>Total Views:</strong> <?php echo number_format($views); ?></p>
                <p><strong>Total Clicks:</strong> <?php echo number_format($clicks); ?></p>
                <p><strong>Click Rate:</strong> <?php echo $ctr; ?>%</p>
                <hr>
                <p class="text-muted mb-0">
                  <small>Created: <?php echo date('M d, Y', strtotime($popup['popup_created_at'])); ?></small><br>
                  <small>Updated: <?php echo date('M d, Y', strtotime($popup['popup_updated_at'])); ?></small>
                </p>
              </div>
            </div>

            <div class="card mt-3">
              <div class="card-header">
                <h6>Tips</h6>
              </div>
              <div class="card-body">
                <ul class="mb-0">
                  <li>Test different positions</li>
                  <li>Adjust delay based on analytics</li>
                  <li>Use clear call-to-action</li>
                  <li>Keep content concise</li>
                </ul>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>
