<?php require'sidebar.php'; ?>

<!-- Link Tracking CSS -->
<link rel="stylesheet" href="../assets/css/link-tracking.css">

<section class="page-container">
<div class="page-content-wrapper">

<div class="content sm-gutter">
<div class="container-fluid padding-25 sm-padding-10">

<div class="row">
<div class="col-12">
<div class="section-title">
  <h5><i class="fas fa-chart-line"></i> Link Tracking & Analytics</h5>
</div>
</div>
</div>

<!-- Filters -->
<div class="row mb-4">
<div class="col-md-12">
<div class="card filter-card">
<div class="card-body">
<form method="GET" action="">
<div class="row">
<div class="col-md-3">
<label>Start Date</label>
<input type="date" name="start_date" class="form-control" value="<?php echo htmlspecialchars($start_date); ?>">
</div>
<div class="col-md-3">
<label>End Date</label>
<input type="date" name="end_date" class="form-control" value="<?php echo htmlspecialchars($end_date); ?>">
</div>
<div class="col-md-4">
<label>Filter by Store</label>
<select name="store" class="form-control">
<option value="0">All Stores</option>
<?php foreach($all_stores as $store): ?>
<option value="<?php echo $store['store_id']; ?>" <?php echo $filter_store == $store['store_id'] ? 'selected' : ''; ?>>
<?php echo htmlspecialchars($store['store_title']); ?>
</option>
<?php endforeach; ?>
</select>
</div>
<div class="col-md-2">
<label>&nbsp;</label>
<button type="submit" class="btn btn-primary btn-block">Filter</button>
</div>
</div>
</form>
</div>
</div>
</div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4 link-tracking-stats">
<div class="col-md-3">
<div class="card bg-primary text-white">
<div class="card-body text-center">
<h3><?php echo number_format($total_clicks); ?></h3>
<p class="mb-0">Total Clicks</p>
</div>
</div>
</div>
<div class="col-md-3">
<div class="card bg-success text-white">
<div class="card-body text-center">
<h3><?php echo number_format($unique_visitors); ?></h3>
<p class="mb-0">Unique Visitors</p>
</div>
</div>
</div>
<div class="col-md-3">
<div class="card bg-warning text-white">
<div class="card-body text-center">
<h3><?php echo count($top_stores); ?></h3>
<p class="mb-0">Active Stores</p>
</div>
</div>
</div>
<div class="col-md-3">
<div class="card bg-danger text-white">
<div class="card-body text-center">
<h3><?php echo number_format($banned_ips_count); ?></h3>
<p class="mb-0">Banned IPs</p>
</div>
</div>
</div>
</div>

<!-- Top Stores -->
<div class="row mb-4 link-tracking-table">
<div class="col-md-12">
<div class="card">
<div class="card-header">
<h5>Top Stores by Clicks</h5>
</div>
<div class="card-body">
<div class="table-responsive">
<table class="table table-hover">
<thead>
<tr>
<th>#</th>
<th>Store</th>
<th>Total Clicks</th>
<th>Unique Visitors</th>
<th>Actions</th>
</tr>
</thead>
<tbody>
<?php $rank = 1; foreach($top_stores as $store): ?>
<tr>
<td><?php echo $rank++; ?></td>
<td>
<img src="<?php echo '../../images/' . $store['store_image']; ?>" alt="" style="width: 30px; height: 30px; object-fit: contain; margin-right: 10px;">
<?php echo htmlspecialchars($store['store_title']); ?>
</td>
<td><span class="badge badge-primary"><?php echo number_format($store['click_count']); ?></span></td>
<td><span class="badge badge-success"><?php echo number_format($store['unique_count']); ?></span></td>
<td>
<a href="?store=<?php echo $store['store_id']; ?>&start_date=<?php echo $start_date; ?>&end_date=<?php echo $end_date; ?>" class="btn btn-sm btn-info">View Details</a>
</td>
</tr>
<?php endforeach; ?>
<?php if(empty($top_stores)): ?>
<tr><td colspan="5" class="text-center">No data available</td></tr>
<?php endif; ?>
</tbody>
</table>
</div>
</div>
</div>
</div>
</div>

<!-- Top Coupons -->
<div class="row mb-4">
<div class="col-md-12">
<div class="card">
<div class="card-header">
<h5>Top Coupons by Clicks</h5>
</div>
<div class="card-body">
<div class="table-responsive">
<table class="table table-hover">
<thead>
<tr>
<th>#</th>
<th>Coupon</th>
<th>Store</th>
<th>Clicks</th>
</tr>
</thead>
<tbody>
<?php $rank = 1; foreach($top_coupons as $coupon): ?>
<tr>
<td><?php echo $rank++; ?></td>
<td><?php echo htmlspecialchars($coupon['coupon_title']); ?></td>
<td><?php echo htmlspecialchars($coupon['store_title']); ?></td>
<td><span class="badge badge-primary"><?php echo number_format($coupon['click_count']); ?></span></td>
</tr>
<?php endforeach; ?>
<?php if(empty($top_coupons)): ?>
<tr><td colspan="4" class="text-center">No data available</td></tr>
<?php endif; ?>
</tbody>
</table>
</div>
</div>
</div>
</div>
</div>

<!-- Device & Browser Stats -->
<div class="row mb-4">
<div class="col-md-6">
<div class="card">
<div class="card-header">
<h5>Device Statistics</h5>
</div>
<div class="card-body">
<table class="table">
<thead>
<tr>
<th>Device</th>
<th>Clicks</th>
<th>Percentage</th>
</tr>
</thead>
<tbody>
<?php foreach($device_data as $device): ?>
<tr>
<td><i class="fas fa-<?php echo $device['device_type'] == 'mobile' ? 'mobile-alt' : ($device['device_type'] == 'tablet' ? 'tablet-alt' : 'desktop'); ?>"></i> <?php echo ucfirst($device['device_type']); ?></td>
<td><?php echo number_format($device['count']); ?></td>
<td><?php echo $total_clicks > 0 ? round(($device['count'] / $total_clicks) * 100, 1) : 0; ?>%</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</div>
</div>
</div>

<div class="col-md-6">
<div class="card">
<div class="card-header">
<h5>Browser Statistics</h5>
</div>
<div class="card-body">
<table class="table">
<thead>
<tr>
<th>Browser</th>
<th>Clicks</th>
<th>Percentage</th>
</tr>
</thead>
<tbody>
<?php foreach($browser_data as $browser): ?>
<tr>
<td><?php echo htmlspecialchars($browser['browser']); ?></td>
<td><?php echo number_format($browser['count']); ?></td>
<td><?php echo $total_clicks > 0 ? round(($browser['count'] / $total_clicks) * 100, 1) : 0; ?>%</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</div>
</div>
</div>
</div>

<!-- Recent Clicks -->
<div class="row mb-4">
<div class="col-md-12">
<div class="card">
<div class="card-header d-flex justify-content-between align-items-center">
<h5>Recent Clicks</h5>
<a href="./banned_ips.php" class="btn btn-danger btn-sm">Manage Banned IPs</a>
</div>
<div class="card-body">
<div class="table-responsive">
<table class="table table-hover table-sm">
<thead>
<tr>
<th>Date/Time</th>
<th>Store</th>
<th>Coupon</th>
<th>IP Address</th>
<th>Device</th>
<th>Browser</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<?php foreach($recent_clicks as $click): ?>
<tr>
<td><?php echo date('M d, Y H:i', strtotime($click['clicked_at'])); ?></td>
<td><?php echo htmlspecialchars($click['store_title']); ?></td>
<td><?php echo $click['coupon_title'] ? htmlspecialchars($click['coupon_title']) : '-'; ?></td>
<td><code><?php echo htmlspecialchars($click['ip_address']); ?></code></td>
<td><?php echo ucfirst($click['device_type']); ?></td>
<td><?php echo htmlspecialchars($click['browser']); ?></td>
<td>
<a href="./ban_ip.php?ip=<?php echo urlencode($click['ip_address']); ?>" class="btn btn-danger btn-xs" onclick="return confirm('Ban this IP address?')">Ban IP</a>
</td>
</tr>
<?php endforeach; ?>
<?php if(empty($recent_clicks)): ?>
<tr><td colspan="7" class="text-center">No clicks recorded</td></tr>
<?php endif; ?>
</tbody>
</table>
</div>
</div>
</div>
</div>
</div>

</div>
</div>

</section>
