<?php require 'sidebar.php'; ?>

<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        
        <div class="section-title d-flex justify-content-between align-items-center">
          <h5>Manage Popups</h5>
          <div>
            <button onclick="clearPopupCache()" class="btn btn-warning mr-2">
              <i class="fa fa-refresh"></i> Clear Cache
            </button>
            <a href="./new_popup.php" class="btn btn-primary">
              <i class="fa fa-plus"></i> Create New Popup
            </a>
          </div>
        </div>

        <?php if (isset($_SESSION['popup_success'])): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?php echo $_SESSION['popup_success']; unset($_SESSION['popup_success']); ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php endif; ?>

        <div class="row">
          <div class="col-12">
            <div class="card">
              <div class="card-body">
                <div class="table-responsive">
                  <table class="table table-hover" id="popupsTable">
                    <thead>
                      <tr>
                        <th>ID</th>
                        <th>Title</th>
                        <th>Type</th>
                        <th>Position</th>
                        <th>Frequency</th>
                        <th>Device</th>
                        <th>Status</th>
                        <th>Priority</th>
                        <th>Views</th>
                        <th>Clicks</th>
                        <th>Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php foreach($popups as $popup): ?>
                      <tr>
                        <td><?php echo $popup['popup_id']; ?></td>
                        <td>
                          <strong><?php echo htmlspecialchars($popup['popup_title']); ?></strong>
                          <?php if($popup['popup_image']): ?>
                          <br><small class="text-muted"><i class="fa fa-image"></i> Has image</small>
                          <?php endif; ?>
                        </td>
                        <td>
                          <span class="badge badge-<?php 
                            echo $popup['popup_type'] == 'offer' ? 'success' : 
                                ($popup['popup_type'] == 'newsletter' ? 'info' : 
                                ($popup['popup_type'] == 'footer' ? 'warning' : 'secondary')); 
                          ?>">
                            <?php echo ucfirst($popup['popup_type']); ?>
                          </span>
                        </td>
                        <td><?php echo ucfirst(str_replace('-', ' ', $popup['popup_position'])); ?></td>
                        <td><?php echo ucfirst($popup['popup_frequency']); ?></td>
                        <td>
                          <span class="badge badge-<?php 
                            echo (!isset($popup['popup_device']) || $popup['popup_device'] == 'both') ? 'primary' : 
                                ($popup['popup_device'] == 'mobile' ? 'info' : 'dark'); 
                          ?>">
                            <?php echo isset($popup['popup_device']) ? ucfirst($popup['popup_device']) : 'Both'; ?>
                          </span>
                        </td>
                        <td>
                          <?php if($popup['popup_enabled']): ?>
                          <span class="badge badge-success">Active</span>
                          <?php else: ?>
                          <span class="badge badge-secondary">Inactive</span>
                          <?php endif; ?>
                        </td>
                        <td><?php echo $popup['popup_priority']; ?></td>
                        <td>
                          <?php
                          $views = $connect->query("SELECT COUNT(*) FROM popup_views WHERE popup_id = {$popup['popup_id']}")->fetchColumn();
                          echo number_format($views);
                          ?>
                        </td>
                        <td>
                          <?php
                          $clicks = $connect->query("SELECT COUNT(*) FROM popup_clicks WHERE popup_id = {$popup['popup_id']}")->fetchColumn();
                          echo number_format($clicks);
                          ?>
                        </td>
                        <td>
                          <a href="./toggle_popup.php?id=<?php echo $popup['popup_id']; ?>" 
                             class="btn btn-sm btn-<?php echo $popup['popup_enabled'] ? 'success' : 'secondary'; ?>" 
                             title="Toggle Status">
                            <i class="fa fa-<?php echo $popup['popup_enabled'] ? 'check' : 'times'; ?>"></i>
                            <?php echo $popup['popup_enabled'] ? 'Active' : 'Inactive'; ?>
                          </a>
                          <a href="./edit_popup.php?id=<?php echo $popup['popup_id']; ?>" 
                             class="btn btn-sm btn-primary" title="Edit">
                            <i class="fa fa-edit"></i>
                          </a>
                          <a href="./delete_popup.php?id=<?php echo $popup['popup_id']; ?>" 
                             class="btn btn-sm btn-danger" 
                             onclick="return confirm('Are you sure you want to delete this popup?')" 
                             title="Delete">
                            <i class="fa fa-trash"></i>
                          </a>
                        </td>
                      </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>

<script>
$(document).ready(function() {
    $('#popupsTable').DataTable({
        order: [[6, 'desc']], // Sort by priority
        pageLength: 25
    });
});

function clearPopupCache() {
    if (confirm('This will clear all popup cache for all users. Continue?')) {
        // Clear localStorage
        Object.keys(localStorage).forEach(key => {
            if (key.startsWith('popup_')) {
                localStorage.removeItem(key);
            }
        });
        
        // Clear sessionStorage
        Object.keys(sessionStorage).forEach(key => {
            if (key.startsWith('popup_')) {
                sessionStorage.removeItem(key);
            }
        });
        
        alert('Popup cache cleared! Popups will show again on next page load.');
    }
}
</script>
