<?php

require './core.php';

header('Content-Type: application/json');

try {
    $connect;
    
    // Get active popups with all fields including timestamps
    $query = $connect->prepare("
        SELECT 
            popup_id, popup_title, popup_type, popup_content, popup_image,
            popup_button_text, popup_button_link, popup_delay, popup_frequency,
            popup_position, popup_width, popup_enabled, popup_show_on_pages, popup_device,
            popup_start_date, popup_end_date, popup_priority,
            popup_created_at, popup_updated_at
        FROM popups 
        WHERE popup_enabled = 1 
        AND (popup_start_date IS NULL OR popup_start_date <= NOW())
        AND (popup_end_date IS NULL OR popup_end_date >= NOW())
        ORDER BY popup_priority DESC
    ");
    
    $query->execute();
    $popups = $query->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'popups' => $popups
    ]);
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}

?>
