<!-- Modern Newsletter Section -->
<div class="modern-newsletter-section">
    <div class="modern-newsletter-container">
        <div class="modern-newsletter-content">
            <div class="modern-newsletter-text">
                <div class="modern-newsletter-icon">📧</div>
                <h3 class="modern-newsletter-title">Stay Updated with Best Deals!</h3>
                <p class="modern-newsletter-description">
                    Subscribe to our newsletter and get exclusive coupons, early access to sales, and weekly deal roundups delivered to your inbox.
                </p>
                <div class="modern-newsletter-features">
                    <div class="modern-newsletter-feature">Exclusive Discounts</div>
                    <div class="modern-newsletter-feature">Early Access</div>
                    <div class="modern-newsletter-feature">Weekly Updates</div>
                </div>
            </div>
            
            <div class="modern-newsletter-form-wrapper">
                <form id="modernNewsletterForm" class="modern-newsletter-form">
                    <div class="modern-newsletter-input-wrapper">
                        <span class="modern-newsletter-input-icon">✉</span>
                        <input type="email" 
                               class="modern-newsletter-input" 
                               placeholder="<?php echo echoOutput($translation['tr_46']); ?>" 
                               required>
                    </div>
                    <button type="submit" class="modern-newsletter-submit">
                        <?php echo echoOutput($translation['tr_45']); ?>
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modern Footer -->
<footer class="modern-footer">
    <div class="footer-wave"></div>
    
    <div class="footer-container">
        <div class="footer-grid">
            
            <!-- Brand Column -->
            <div class="footer-column footer-brand">
                <?php if(isset($theme['th_logo']) && !empty($theme['th_logo'])): ?>
                    <img src="<?php echo $urlPath->image($theme['th_logo']); ?>" alt="Logo" class="footer-logo-img">
                <?php endif; ?>
                
                <p class="footer-description">
                    <strong>AloneDeals</strong> is India's trusted platform for online deals, discount coupons, and special offers. Save more every day with our curated coupons and exclusive affiliate deals.
                </p>
                
                <div class="footer-social">
                    <?php foreach($socialMedia as $item): ?>
                        <?php if (!empty($item['st_facebook'])): ?>
                        <a href="<?php echo $item['st_facebook'] ?>" class="social-icon social-facebook" target="_blank" title="Facebook">
                            <i class="ti ti-brand-facebook"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($item['st_twitter'])): ?>
                        <a href="<?php echo $item['st_twitter'] ?>" class="social-icon social-x" target="_blank" title="X (Twitter)">
                            <svg viewBox="0 0 24 24" width="20" height="20" fill="currentColor">
                                <path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/>
                            </svg>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($item['st_instagram'])): ?>
                        <a href="<?php echo $item['st_instagram'] ?>" class="social-icon social-instagram" target="_blank" title="Instagram">
                            <i class="ti ti-brand-instagram"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($item['st_linkedin'])): ?>
                        <a href="<?php echo $item['st_linkedin'] ?>" class="social-icon social-linkedin" target="_blank" title="LinkedIn">
                            <i class="ti ti-brand-linkedin"></i>
                        </a>
                        <?php endif; ?>
                        <?php if (!empty($item['st_whatsapp'])): ?>
                        <a href="<?php echo $item['st_whatsapp'] ?>" class="social-icon social-whatsapp" target="_blank" title="WhatsApp">
                            <i class="ti ti-brand-whatsapp"></i>
                        </a>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <!-- Explore Column -->
            <div class="footer-column">
                <h4>Explore</h4>
                <ul class="footer-links">
                    <li><a href="<?php echo $urlPath->stores(); ?>">All Stores</a></li>
                    <li><a href="<?php echo $urlPath->categories(); ?>">All Categories</a></li>
                    <li><a href="<?php echo $urlPath->blog(); ?>">Blog Posts</a></li>
                    <?php foreach($navigationFooter as $item): ?>
                        <?php if ($item['navigation_type'] == 'custom') { ?>
                            <?php if($item['navigation_url'] == '/'){ ?>
                            <li><a href="<?php echo $urlPath->home(); ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
                            <?php }else{ ?>
                            <li><a href="<?php echo $item['navigation_url']; ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
                            <?php } ?>
                        <?php } else { ?>
                        <li><a href="<?php echo $urlPath->page($item['navigation_url']); ?>" target="<?php echo $item['navigation_target']; ?>"><?php echo echoOutput($item['navigation_label']); ?></a></li>
                        <?php } ?>
                    <?php endforeach; ?>
                </ul>
            </div>
            
            <!-- Legal & Support Column -->
            <div class="footer-column">
                <h4>Legal & Support</h4>
                <ul class="footer-links">
                    <li><a href="<?php echo $urlPath->page('about-us'); ?>">About Us</a></li>
                    <li><a href="<?php echo $urlPath->page('contact-us'); ?>">Contact Us</a></li>
                    <li><a href="<?php echo $urlPath->page('faq'); ?>">FAQ</a></li>
                    <li><a href="<?php echo $urlPath->page('terms-and-conditions'); ?>">Terms & Conditions</a></li>
                    <li><a href="<?php echo $urlPath->page('privacy-policy'); ?>">Privacy Policy</a></li>
                </ul>
            </div>
            
            <!-- Contact Column -->
            <div class="footer-column">
                <h4>Contact Us</h4>
                <div class="footer-contact-info">
                    <?php if (!empty($settings['st_email'])): ?>
                    <div class="footer-contact-item">
                        <i class="ti ti-mail"></i>
                        <span><?php echo echoOutput($settings['st_email']); ?></span>
                    </div>
                    <?php endif; ?>
                    <?php if (!empty($settings['st_phone'])): ?>
                    <div class="footer-contact-item">
                        <i class="ti ti-phone"></i>
                        <span><?php echo echoOutput($settings['st_phone']); ?></span>
                    </div>
                    <?php endif; ?>
                    <?php if (!empty($settings['st_address'])): ?>
                    <div class="footer-contact-item">
                        <i class="ti ti-map-pin"></i>
                        <span><?php echo echoOutput($settings['st_address']); ?></span>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            
        </div>
        
        <!-- Footer Bottom -->
        <div class="footer-bottom">
            <div class="footer-bottom-content" style="justify-content: center;">
                <div class="footer-copyright">
                    © <?php echo date('Y'); ?> <a href="<?php echo $urlPath->home(); ?>">Alonedeals.com</a>. All Rights Reserved.
                </div>
            </div>
        </div>
    </div>
    
    <!-- DMCA Badge -->
   <div class="footer-dmca">
        <a href="//www.dmca.com/Protection/Status.aspx?ID=1901296e-c7de-4c4f-bcc0-60d255233cb1" title="DMCA.com Protection Status" class="dmca-badge"> <img src ="https://images.dmca.com/Badges/dmca-badge-w150-5x1-01.png?ID=1901296e-c7de-4c4f-bcc0-60d255233cb1"  alt="DMCA.com Protection Status" /></a>  <script src="https://images.dmca.com/Badges/DMCABadgeHelper.min.js"> </script>
    </div>
</footer>

<!-- Scroll to Top Button -->
<button class="scroll-to-top" id="scrollToTop" onclick="scrollToTop()">
    <i class="ti ti-arrow-up"></i>
</button>

<script>
// Scroll to Top functionality
window.addEventListener('scroll', function() {
    const scrollBtn = document.getElementById('scrollToTop');
    if (window.pageYOffset > 300) {
        scrollBtn.classList.add('show');
    } else {
        scrollBtn.classList.remove('show');
    }
});

function scrollToTop() {
    window.scrollTo({
        top: 0,
        behavior: 'smooth'
    });
}
</script>

<!-- Centralized Footer CSS & JS -->
<?php include __DIR__ . '/../../views/includes/footer-css.php'; ?>
<?php include __DIR__ . '/../../views/includes/footer-js.php'; ?>

<!-- Notification Bell -->
<script src="<?php echo $urlPath->assets_js('notification-bell.js'); ?>"></script>