<?php

require "core.php";

// Load SEO features only if files exist (for production compatibility)
if (file_exists("includes/breadcrumb_schema.php")) {
    require "includes/breadcrumb_schema.php";
}
if (file_exists("includes/advanced_seo_system.php")) {
    require "includes/advanced_seo_system.php";
}

// Get Item Slug
$itemId = clearGetData(getItemId());

if(empty($itemId)){

	header('Location: '. $urlPath->home());
}

// Page Details
$itemDetails = getCouponById($connect, $itemId);

if(empty($itemDetails)){

	header('Location: '. $urlPath->error());
}

$itemsGallery = getItemsGallery($connect, $itemId);

// Seo Title
$titleSeoHeader = getSeoTitle(empty($itemDetails['coupon_seotitle']) ? $itemDetails['coupon_title'] : $itemDetails['coupon_seotitle']);

// Seo Description
$descriptionSeoHeader = getSeoDescription($translation['tr_3'], $itemDetails['coupon_description'], $itemDetails['coupon_seodescription']);

// Canonical URL
$canonicalUrl = SITE_URL . '/coupon/' . $itemDetails['coupon_slug'];

// Generate Breadcrumb Schema
$storeName = '';
$storeSlug = '';
if (!empty($itemDetails['store_id'])) {
    $storeData = $connect->query("SELECT store_title, store_slug FROM stores WHERE store_id = " . $itemDetails['store_id'])->fetch(PDO::FETCH_ASSOC);
    if ($storeData) {
        $storeName = $storeData['store_title'];
        $storeSlug = $storeData['store_slug'];
    }
}

// Generate Breadcrumb Schema (if class exists)
if (class_exists('BreadcrumbSchema')) {
    $breadcrumb = BreadcrumbSchema::forCoupon(
        $itemDetails['coupon_title'],
        $itemDetails['coupon_slug'],
        $storeName,
        $storeSlug
    );
}

// Initialize SEO System (if class exists)
if (class_exists('AdvancedSEOSystem')) {
    $seo = new AdvancedSEOSystem($connect, 'https://alonedeals.com');
}


// Page Title
$pageTitle = $itemDetails['coupon_title'];

if (isLogged()) {

$isFav = isInFav($connect, $userInfo['user_id'], $itemId);

}

include './header.php';
require './views/single-coupon.view.php';
include './footer.php';

?>