<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html><html><head><title>Blog Step Test</title></head><body>";
echo "<h1>Blog Loading Test - Step by Step</h1>";

try {
    echo "<p>Step 1: Loading core.php...</p>";
    require "core.php";
    echo "<p style='color:green;'>✓ core.php loaded</p>";
    
    echo "<p>Step 2: Checking if breadcrumb_schema.php exists...</p>";
    if (file_exists("includes/breadcrumb_schema.php")) {
        echo "<p style='color:green;'>✓ File exists</p>";
        echo "<p>Step 3: Loading breadcrumb_schema.php...</p>";
        require "includes/breadcrumb_schema.php";
        echo "<p style='color:green;'>✓ breadcrumb_schema.php loaded</p>";
    } else {
        echo "<p style='color:red;'>✗ breadcrumb_schema.php NOT FOUND</p>";
    }
    
    echo "<p>Step 4: Checking if advanced_seo_system.php exists...</p>";
    if (file_exists("includes/advanced_seo_system.php")) {
        echo "<p style='color:green;'>✓ File exists</p>";
        echo "<p>Step 5: Loading advanced_seo_system.php...</p>";
        require "includes/advanced_seo_system.php";
        echo "<p style='color:green;'>✓ advanced_seo_system.php loaded</p>";
    } else {
        echo "<p style='color:red;'>✗ advanced_seo_system.php NOT FOUND</p>";
    }
    
    echo "<p>Step 6: Creating BreadcrumbSchema object...</p>";
    $breadcrumb = new BreadcrumbSchema();
    echo "<p style='color:green;'>✓ BreadcrumbSchema created</p>";
    
    echo "<p>Step 7: Adding breadcrumb item...</p>";
    $breadcrumb->addItem('Blog', SITE_URL . '/Post');
    echo "<p style='color:green;'>✓ Breadcrumb item added</p>";
    
    echo "<p>Step 8: Creating AdvancedSEOSystem object...</p>";
    $seo = new AdvancedSEOSystem($connect, SITE_URL);
    echo "<p style='color:green;'>✓ AdvancedSEOSystem created</p>";
    
    echo "<p>Step 9: Testing database query...</p>";
    $totalPosts = $connect->query("SELECT COUNT(*) FROM blog_posts WHERE post_status = 'published'")->fetchColumn();
    echo "<p style='color:green;'>✓ Found $totalPosts published posts</p>";
    
    echo "<p>Step 10: Testing blog posts query...</p>";
    $query = "SELECT bp.*, bc.blog_cat_name, bc.blog_cat_slug, u.user_name 
              FROM blog_posts bp
              LEFT JOIN blog_categories bc ON bp.post_category = bc.blog_cat_id
              LEFT JOIN users u ON bp.post_author = u.user_id
              WHERE bp.post_status = 'published'
              ORDER BY bp.published_at DESC
              LIMIT 12";
    $posts = $connect->query($query)->fetchAll(PDO::FETCH_ASSOC);
    echo "<p style='color:green;'>✓ Query executed, got " . count($posts) . " posts</p>";
    
    echo "<p>Step 11: Testing getSeoTitle function...</p>";
    $titleSeoHeader = getSeoTitle($translation['tr_1'], "Blog - Latest News & Articles");
    echo "<p style='color:green;'>✓ getSeoTitle works: " . htmlspecialchars($titleSeoHeader) . "</p>";
    
    echo "<p>Step 12: Testing getSeoDescription function...</p>";
    $descriptionSeoHeader = getSeoDescription($translation['tr_3'], "Read the latest tech news, shopping tips, and deal alerts on our blog.");
    echo "<p style='color:green;'>✓ getSeoDescription works</p>";
    
    echo "<h2 style='color:green;'>✓✓✓ ALL STEPS PASSED! ✓✓✓</h2>";
    echo "<p>The blog system is working. The 500 error must be in one of the view files.</p>";
    echo "<p><a href='blog.php'>Try Blog Page Now</a></p>";
    
} catch (Throwable $e) {
    echo "<h2 style='color:red;'>✗ ERROR at current step:</h2>";
    echo "<div style='background:#f8d7da;padding:20px;border-radius:8px;'>";
    echo "<strong>Error:</strong> " . htmlspecialchars($e->getMessage()) . "<br><br>";
    echo "<strong>File:</strong> " . htmlspecialchars($e->getFile()) . "<br>";
    echo "<strong>Line:</strong> " . $e->getLine() . "<br><br>";
    echo "<strong>Stack Trace:</strong><pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
    echo "</div>";
}

echo "</body></html>";
?>
