<?php
/**
 * Test the actual edit_product.php file with error display
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

echo "<!DOCTYPE html><html><head><title>Edit Product Real Test</title></head><body>";
echo "<h1>Testing Actual edit_product.php File</h1>";

// Set up session to simulate logged-in admin
session_start();

// You need to replace this with your actual admin email
$_SESSION['user_email'] = 'admin@alonedeals.com'; // CHANGE THIS TO YOUR ADMIN EMAIL

// Set product ID
$_GET['id'] = 11; // Testing with product ID 11

echo "<p>Session email: " . $_SESSION['user_email'] . "</p>";
echo "<p>Product ID: " . $_GET['id'] . "</p>";
echo "<hr>";

// Try to include the actual file
try {
    ob_start();
    include 'admin/controller/edit_product.php';
    $output = ob_get_clean();
    
    echo "<h2 style='color:green;'>✓ Page loaded successfully!</h2>";
    echo "<p>Output length: " . strlen($output) . " bytes</p>";
    echo "<hr>";
    echo $output;
    
} catch (Throwable $e) {
    ob_end_clean();
    echo "<h2 style='color:red;'>✗ ERROR FOUND:</h2>";
    echo "<div style='background:#f8d7da;padding:20px;border-radius:8px;margin:20px 0;'>";
    echo "<strong>Error Message:</strong><br>";
    echo "<pre style='color:#721c24;font-size:16px;'>" . htmlspecialchars($e->getMessage()) . "</pre>";
    echo "<br><strong>Error File:</strong> " . htmlspecialchars($e->getFile()) . "<br>";
    echo "<strong>Error Line:</strong> " . $e->getLine() . "<br><br>";
    echo "<strong>Stack Trace:</strong>";
    echo "<pre style='font-size:12px;'>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
    echo "</div>";
    
    echo "<h3>Possible Solutions:</h3>";
    echo "<ul>";
    echo "<li>Check if the error file exists and has correct syntax</li>";
    echo "<li>Check if all required functions are defined</li>";
    echo "<li>Check if database tables exist</li>";
    echo "<li>Check if view files exist</li>";
    echo "</ul>";
}

echo "</body></html>";
?>
