<?php
/**
 * Simple Test - Edit Store Access
 */

// Enable all errors
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<!DOCTYPE html><html><head><title>Test Edit Store</title></head><body>";
echo "<h1>Testing Edit Store Access</h1>";

// Start session
session_start();

// Check if logged in
if (!isset($_SESSION['user_email'])) {
    echo "<p style='color:red;'>❌ Not logged in. Please login first.</p>";
    echo "<p><a href='admin/'>Go to Admin Login</a></p>";
    exit;
}

echo "<p style='color:green;'>✓ Session active: " . $_SESSION['user_email'] . "</p>";

// Load config
try {
    require 'config.php';
    echo "<p style='color:green;'>✓ Config loaded</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ Config error: " . $e->getMessage() . "</p>";
    exit;
}

// Load functions
try {
    require 'admin/functions.php';
    echo "<p style='color:green;'>✓ Functions loaded</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ Functions error: " . $e->getMessage() . "</p>";
    exit;
}

// Connect to database
try {
    $connect = connect($database);
    echo "<p style='color:green;'>✓ Database connected</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ Database error: " . $e->getMessage() . "</p>";
    exit;
}

// Check access
try {
    $check_access = check_access($connect);
    echo "<p style='color:green;'>✓ Access check passed</p>";
    echo "<p>User role: " . $check_access['user_role'] . "</p>";
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ Access check error: " . $e->getMessage() . "</p>";
    exit;
}

// Get a store to test
try {
    $stmt = $connect->query("SELECT store_id, store_title FROM stores LIMIT 1");
    $store = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($store) {
        echo "<p style='color:green;'>✓ Found test store: " . $store['store_title'] . " (ID: " . $store['store_id'] . ")</p>";
        echo "<p><strong>Try accessing:</strong></p>";
        echo "<ul>";
        echo "<li><a href='admin/controller/edit_store.php?id=" . $store['store_id'] . "' target='_blank'>Edit Store (Direct Link)</a></li>";
        echo "<li><a href='admin/?page=edit_store&id=" . $store['store_id'] . "' target='_blank'>Edit Store (Admin Panel)</a></li>";
        echo "</ul>";
    } else {
        echo "<p style='color:orange;'>⚠ No stores found in database</p>";
    }
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ Store query error: " . $e->getMessage() . "</p>";
}

// Check for PHP errors in edit_store.php
echo "<hr>";
echo "<h2>Checking edit_store.php for syntax errors...</h2>";

$file = 'admin/controller/edit_store.php';
if (file_exists($file)) {
    // Try to include it in a safe way
    ob_start();
    $error = null;
    try {
        // Don't actually include, just check syntax
        $code = file_get_contents($file);
        if (strpos($code, '<?php') !== false) {
            echo "<p style='color:green;'>✓ File has valid PHP opening tag</p>";
        }
        
        // Check for common issues
        if (strpos($code, 'header-css-optimized') !== false) {
            echo "<p style='color:red;'>❌ Found reference to header-css-optimized (might cause issues)</p>";
        }
        if (strpos($code, 'header-js-optimized') !== false) {
            echo "<p style='color:red;'>❌ Found reference to header-js-optimized (might cause issues)</p>";
        }
        
    } catch (Exception $e) {
        $error = $e->getMessage();
    }
    $output = ob_get_clean();
    
    if ($error) {
        echo "<p style='color:red;'>❌ Error: $error</p>";
    } else {
        echo "<p style='color:green;'>✓ No obvious syntax errors detected</p>";
    }
} else {
    echo "<p style='color:red;'>❌ File not found: $file</p>";
}

echo "</body></html>";
?>
