<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">

<style>
:root {
    --primary-color: #6366f1;
    --primary-dark: #4f46e5;
    --secondary-color: #8b5cf6;
    --text-primary: #0f172a;
    --text-secondary: #475569;
    --text-light: #64748b;
    --bg-primary: #ffffff;
    --bg-secondary: #f8fafc;
    --bg-accent: #f1f5f9;
    --border-color: #e2e8f0;
    --shadow-sm: 0 1px 3px rgba(0,0,0,0.05);
    --shadow-md: 0 4px 12px rgba(0,0,0,0.08);
    --shadow-lg: 0 10px 30px rgba(0,0,0,0.12);
}

body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
}

.blog-listing-page {
    background: var(--bg-secondary);
    min-height: 100vh;
    padding: 50px 0;
}

.blog-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 24px;
}

.blog-hero {
    text-align: center;
    margin-bottom: 60px;
}

.blog-hero h1 {
    font-size: 48px;
    font-weight: 800;
    color: var(--text-primary);
    margin: 0 0 16px 0;
    letter-spacing: -0.02em;
}

.blog-hero p {
    font-size: 18px;
    color: var(--text-secondary);
    margin: 0;
}

.blog-layout {
    display: grid;
    grid-template-columns: 1fr 320px;
    gap: 40px;
}

/* Featured Post */
.featured-post {
    background: var(--bg-primary);
    border-radius: 12px;
    overflow: hidden;
    box-shadow: var(--shadow-md);
    margin-bottom: 48px;
    transition: all 0.3s;
}

.featured-post:hover {
    box-shadow: var(--shadow-lg);
}

.featured-content {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 0;
}

.featured-image {
    position: relative;
    overflow: hidden;
}

.featured-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s;
}

.featured-post:hover .featured-image img {
    transform: scale(1.05);
}

.featured-badge {
    position: absolute;
    top: 20px;
    left: 20px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: white;
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.featured-body {
    padding: 48px;
    display: flex;
    flex-direction: column;
    justify-content: space-between;
}

.featured-title {
    font-size: 32px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 16px 0;
    line-height: 1.3;
    letter-spacing: -0.01em;
}

.featured-title a {
    color: inherit;
    text-decoration: none;
    transition: color 0.2s;
}

.featured-title a:hover {
    color: var(--primary-color);
}

.featured-excerpt {
    font-size: 16px;
    color: var(--text-secondary);
    line-height: 1.6;
    margin: 0 0 24px 0;
}

.featured-meta {
    display: flex;
    align-items: center;
    gap: 20px;
    font-size: 14px;
    color: var(--text-light);
    margin-bottom: 24px;
}

.featured-meta i {
    margin-right: 4px;
}

.featured-btn {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    padding: 12px 24px;
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: white;
    border-radius: 8px;
    text-decoration: none;
    font-weight: 600;
    font-size: 15px;
    transition: all 0.3s;
    align-self: flex-start;
}

.featured-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(99, 102, 241, 0.3);
}

/* Blog Grid */
.blog-grid {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(320px, 1fr));
    gap: 28px;
    margin-bottom: 48px;
}

.blog-card {
    background: var(--bg-primary);
    border-radius: 12px;
    overflow: hidden;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--border-color);
    transition: all 0.3s;
    display: flex;
    flex-direction: column;
}

.blog-card:hover {
    transform: translateY(-6px);
    box-shadow: var(--shadow-lg);
    border-color: var(--primary-color);
}

.blog-card-image {
    position: relative;
    overflow: hidden;
    height: 220px;
}

.blog-card-image img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: transform 0.3s;
}

.blog-card:hover .blog-card-image img {
    transform: scale(1.08);
}

.blog-card-badge {
    position: absolute;
    top: 16px;
    right: 16px;
    background: white;
    color: var(--primary-color);
    padding: 6px 14px;
    border-radius: 20px;
    font-size: 11px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
    box-shadow: var(--shadow-sm);
}

.blog-card-body {
    padding: 24px;
    flex: 1;
    display: flex;
    flex-direction: column;
}

.blog-card-title {
    font-size: 20px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 12px 0;
    line-height: 1.4;
}

.blog-card-title a {
    color: inherit;
    text-decoration: none;
    transition: color 0.2s;
}

.blog-card-title a:hover {
    color: var(--primary-color);
}

.blog-card-excerpt {
    font-size: 14px;
    color: var(--text-secondary);
    line-height: 1.6;
    margin: 0 0 16px 0;
    flex: 1;
}

.blog-card-meta {
    display: flex;
    align-items: center;
    gap: 16px;
    font-size: 13px;
    color: var(--text-light);
    padding-top: 16px;
    border-top: 1px solid var(--border-color);
}

.blog-card-meta i {
    margin-right: 4px;
}

/* Sidebar */
.blog-sidebar {
    position: sticky;
    top: 24px;
    height: fit-content;
}

.sidebar-widget {
    background: var(--bg-primary);
    border-radius: 12px;
    padding: 28px;
    margin-bottom: 24px;
    box-shadow: var(--shadow-sm);
    border: 1px solid var(--border-color);
}

.widget-title {
    font-size: 18px;
    font-weight: 700;
    color: var(--text-primary);
    margin: 0 0 20px 0;
    padding-bottom: 12px;
    border-bottom: 2px solid var(--primary-color);
}

.category-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.category-item {
    padding: 12px 0;
    border-bottom: 1px solid var(--border-color);
}

.category-item:last-child {
    border-bottom: none;
}

.category-link {
    display: flex;
    justify-content: space-between;
    align-items: center;
    color: var(--text-secondary);
    text-decoration: none;
    font-size: 15px;
    transition: color 0.2s;
}

.category-link:hover {
    color: var(--primary-color);
}

.category-count {
    background: var(--bg-accent);
    color: var(--text-secondary);
    padding: 4px 10px;
    border-radius: 12px;
    font-size: 12px;
    font-weight: 600;
}

.category-link:hover .category-count {
    background: var(--primary-color);
    color: white;
}

/* Newsletter Widget */
.newsletter-widget {
    background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
    color: white;
}

.newsletter-widget .widget-title {
    color: white;
    border-bottom-color: rgba(255, 255, 255, 0.3);
}

.newsletter-text {
    font-size: 14px;
    line-height: 1.6;
    margin: 0 0 20px 0;
    opacity: 0.95;
}

.newsletter-form input {
    width: 100%;
    padding: 12px 16px;
    border: 1px solid rgba(255, 255, 255, 0.3);
    border-radius: 8px;
    background: rgba(255, 255, 255, 0.15);
    color: white;
    font-size: 14px;
    margin-bottom: 12px;
}

.newsletter-form input::placeholder {
    color: rgba(255, 255, 255, 0.7);
}

.newsletter-form button {
    width: 100%;
    padding: 12px;
    background: white;
    color: var(--primary-color);
    border: none;
    border-radius: 8px;
    font-weight: 600;
    font-size: 14px;
    cursor: pointer;
    transition: all 0.2s;
}

.newsletter-form button:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
}

/* Pagination */
.pagination {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 8px;
    margin-top: 48px;
}

.pagination a,
.pagination span {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    min-width: 40px;
    height: 40px;
    padding: 0 12px;
    background: var(--bg-primary);
    color: var(--text-secondary);
    border: 1px solid var(--border-color);
    border-radius: 8px;
    text-decoration: none;
    font-weight: 500;
    font-size: 14px;
    transition: all 0.2s;
}

.pagination a:hover {
    background: var(--primary-color);
    color: white;
    border-color: var(--primary-color);
}

.pagination .active {
    background: var(--primary-color);
    color: white;
    border-color: var(--primary-color);
}

.empty-state {
    text-align: center;
    padding: 80px 20px;
    background: var(--bg-primary);
    border-radius: 12px;
    box-shadow: var(--shadow-sm);
}

.empty-state i {
    font-size: 64px;
    color: var(--text-light);
    margin-bottom: 20px;
}

.empty-state h3 {
    font-size: 24px;
    color: var(--text-primary);
    margin: 0 0 12px 0;
}

.empty-state p {
    font-size: 16px;
    color: var(--text-secondary);
    margin: 0;
}

@media (max-width: 1024px) {
    .blog-layout {
        grid-template-columns: 1fr;
    }
    
    .blog-sidebar {
        position: static;
    }
}

@media (max-width: 768px) {
    .blog-hero h1 {
        font-size: 36px;
    }
    
    .featured-content {
        grid-template-columns: 1fr;
    }
    
    .featured-image {
        height: 300px;
    }
    
    .featured-body {
        padding: 32px;
    }
    
    .featured-title {
        font-size: 24px;
    }
    
    .blog-grid {
        grid-template-columns: 1fr;
    }
}
</style>

<div class="blog-listing-page">
    <div class="blog-container">
        <!-- Hero Section -->
        <div class="blog-hero">
            <h1>📰 Our Blog</h1>
            <p>Discover the latest news, tips, and insights</p>
        </div>

        <div class="blog-layout">
            <!-- Main Content -->
            <div class="blog-main">
                <!-- Featured Post -->
                <?php if(!empty($posts) && isset($posts[0])): 
                    $featuredPost = $posts[0];
                ?>
                <article class="featured-post">
                    <div class="featured-content">
                        <?php if($featuredPost['post_featured_image']): ?>
                        <div class="featured-image">
                            <a href="<?php echo SITE_URL; ?>/Post/<?php echo $featuredPost['post_slug']; ?>">
                                <img src="<?php echo getImageUrl($featuredPost['post_featured_image_cdn_url'], $featuredPost['post_use_cdn'], $featuredPost['post_featured_image']); ?>" 
                                     alt="<?php echo htmlspecialchars($featuredPost['post_title']); ?>">
                            </a>
                            <?php if($featuredPost['blog_cat_name']): ?>
                            <span class="featured-badge">
                                <i class="fa fa-folder"></i> <?php echo htmlspecialchars($featuredPost['blog_cat_name']); ?>
                            </span>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        
                        <div class="featured-body">
                            <div>
                                <h2 class="featured-title">
                                    <a href="<?php echo SITE_URL; ?>/Post/<?php echo $featuredPost['post_slug']; ?>">
                                        <?php echo htmlspecialchars($featuredPost['post_title']); ?>
                                    </a>
                                </h2>
                                <p class="featured-excerpt">
                                    <?php echo htmlspecialchars(substr(strip_tags($featuredPost['post_excerpt'] ?: $featuredPost['post_content']), 0, 180)) . '...'; ?>
                                </p>
                                <div class="featured-meta">
                                    <span><i class="fa fa-calendar"></i> <?php echo date('M d, Y', strtotime($featuredPost['published_at'])); ?></span>
                                    <span><i class="fa fa-eye"></i> <?php echo number_format($featuredPost['post_views']); ?> views</span>
                                </div>
                            </div>
                            <a href="<?php echo SITE_URL; ?>/Post/<?php echo $featuredPost['post_slug']; ?>" class="featured-btn">
                                Read Article <i class="fa fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </article>
                <?php 
                    array_shift($posts);
                endif; 
                ?>

                <!-- Blog Grid -->
                <?php if(empty($posts)): ?>
                <div class="empty-state">
                    <i class="fa fa-file-text"></i>
                    <h3>No posts found</h3>
                    <p>Check back later for new content</p>
                </div>
                <?php else: ?>
                <div class="blog-grid">
                    <?php foreach($posts as $post): ?>
                    <article class="blog-card">
                        <?php if($post['post_featured_image']): ?>
                        <div class="blog-card-image">
                            <a href="<?php echo SITE_URL; ?>/Post/<?php echo $post['post_slug']; ?>">
                                <img src="<?php echo getImageUrl($post['post_featured_image_cdn_url'], $post['post_use_cdn'], $post['post_featured_image']); ?>" 
                                     alt="<?php echo htmlspecialchars($post['post_title']); ?>">
                            </a>
                            <?php if($post['blog_cat_name']): ?>
                            <span class="blog-card-badge">
                                <?php echo htmlspecialchars($post['blog_cat_name']); ?>
                            </span>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        
                        <div class="blog-card-body">
                            <h3 class="blog-card-title">
                                <a href="<?php echo SITE_URL; ?>/Post/<?php echo $post['post_slug']; ?>">
                                    <?php echo htmlspecialchars($post['post_title']); ?>
                                </a>
                            </h3>
                            <p class="blog-card-excerpt">
                                <?php echo htmlspecialchars(substr(strip_tags($post['post_excerpt'] ?: $post['post_content']), 0, 100)) . '...'; ?>
                            </p>
                            <div class="blog-card-meta">
                                <span><i class="fa fa-calendar"></i> <?php echo date('M d, Y', strtotime($post['published_at'])); ?></span>
                                <span><i class="fa fa-eye"></i> <?php echo number_format($post['post_views']); ?></span>
                            </div>
                        </div>
                    </article>
                    <?php endforeach; ?>
                </div>

                <!-- Pagination -->
                <?php if($totalPages > 1): ?>
                <div class="pagination">
                    <?php if($currentPage > 1): ?>
                    <a href="?page=<?php echo $currentPage - 1; ?><?php echo $categoryFilter ? '&category=' . $categoryFilter : ''; ?>">
                        <i class="fa fa-chevron-left"></i>
                    </a>
                    <?php endif; ?>
                    
                    <?php for($i = 1; $i <= $totalPages; $i++): ?>
                    <?php if($i == $currentPage): ?>
                    <span class="active"><?php echo $i; ?></span>
                    <?php else: ?>
                    <a href="?page=<?php echo $i; ?><?php echo $categoryFilter ? '&category=' . $categoryFilter : ''; ?>"><?php echo $i; ?></a>
                    <?php endif; ?>
                    <?php endfor; ?>
                    
                    <?php if($currentPage < $totalPages): ?>
                    <a href="?page=<?php echo $currentPage + 1; ?><?php echo $categoryFilter ? '&category=' . $categoryFilter : ''; ?>">
                        <i class="fa fa-chevron-right"></i>
                    </a>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                <?php endif; ?>
            </div>

            <!-- Sidebar -->
            <aside class="blog-sidebar">
                <!-- Categories Widget -->
                <div class="sidebar-widget">
                    <h3 class="widget-title"><i class="fa fa-folder-open"></i> Categories</h3>
                    <ul class="category-list">
                        <li class="category-item">
                            <a href="<?php echo SITE_URL; ?>/Post" class="category-link">
                                <span>All Posts</span>
                                <span class="category-count"><?php echo $totalPosts; ?></span>
                            </a>
                        </li>
                        <?php foreach($blogCategories as $cat): ?>
                        <li class="category-item">
                            <a href="<?php echo SITE_URL; ?>/Post?category=<?php echo $cat['blog_cat_id']; ?>" class="category-link">
                                <span><?php echo htmlspecialchars($cat['blog_cat_name']); ?></span>
                                <span class="category-count"><?php echo $cat['post_count']; ?></span>
                            </a>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>

                <!-- Newsletter Widget -->
                <div class="sidebar-widget newsletter-widget">
                    <h3 class="widget-title"><i class="fa fa-envelope"></i> Newsletter</h3>
                    <p class="newsletter-text">Get the latest posts delivered right to your inbox.</p>
                    <form class="newsletter-form" onsubmit="return false;">
                        <input type="email" placeholder="Enter your email..." required>
                        <button type="submit">Subscribe Now</button>
                    </form>
                </div>
            </aside>
        </div>
    </div>
</div>
