<div class="uk-position-top-right uk-position-z-index uk-padding-small">
<a onclick="goBack()" uk-close></a>
</div>

<div class="uk-height-1-1 tas-section-padding-v-s uk-panel uk-flex uk-flex-wrap uk-flex-middle uk-flex-center" uk-scrollspy="target: > div; cls: uk-animation-fade; delay: 100">

<div class="tas-auth-card">

<a href="<?php echo $urlPath->home(); ?>">
<img class="tas-logo" src="<?php echo $urlPath->image($theme['th_logo']); ?>">
</a>

<h5 class="uk-heading-line"><span><?php echo echoOutput($translation['tr_151']); ?></span></h5>

<!-- Tab Navigation -->
<ul class="uk-tab uk-flex-center auth-tabs" uk-tab>
    <li class="uk-active"><a href="#">Email</a></li>
    <li><a href="#">Mobile</a></li>
</ul>

<!-- Tab Content -->
<ul class="uk-switcher uk-margin">
    
    <!-- Email Signup -->
    <li>
        <form class="uk-form" action="<?php echo htmlspecialchars($urlPath->signup()); ?>" method="post">

            <div class="uk-margin">
                <div class="uk-width-1-1 uk-inline">
                    <span class="uk-form-icon" uk-icon="icon: user"></span>
                    <input class="uk-input uk-border-pill" placeholder="<?php echo echoOutput($translation['tr_152']); ?>" name="user_name" type="text" required="">
                </div>
            </div>

            <div class="uk-margin">
                <div class="uk-width-1-1 uk-inline">
                    <span class="uk-form-icon" uk-icon="icon: mail"></span>
                    <input class="uk-input uk-border-pill" placeholder="<?php echo echoOutput($translation['tr_145']); ?>" name="user_email" type="email" required="">
                </div>
            </div>

            <div class="uk-margin">
                <div class="uk-width-1-1 uk-inline">
                    <span class="uk-form-icon" uk-icon="icon: lock"></span>
                    <input class="uk-input uk-border-pill" placeholder="<?php echo echoOutput($translation['tr_146']); ?>" name="user_password" type="password" required="">
                    <small class="uk-text-muted">Minimum 8 characters</small>
                </div>
            </div>

            <div class="uk-margin">
                <label>
                    <input class="uk-checkbox" type="checkbox" name="ischecked" value="1" required="">
                    I agree to the <a href="<?php echo $urlPath->terms(); ?>" target="_blank">Terms</a> and <a href="<?php echo $urlPath->privacy(); ?>" target="_blank">Privacy Policy</a>
                </label>
            </div>

            <?php if(!empty($errors)): ?>
            <div class="uk-width-1-1 uk-text-left">
                <div class="uk-margin">
                    <div class="tas-notify tas-notify-danger uk-text-small uk-border-rounded uk-margin-remove">
                        <ul class="uk-margin-remove">
                        <?php foreach($errors as $key => $value):?>
                            <li><?php echo echoOutput($value); ?></li>
                        <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="g-recaptcha" data-sitekey="<?php echo $siteKey; ?>"></div>

            <button class="uk-button uk-width-1-1 uk-border-pill uk-button-primary uk-margin-small-top" type="submit"><?php echo echoOutput($translation['tr_153']); ?></button>

        </form>
    </li>
    
    <!-- Mobile Signup -->
    <li>
        <form class="uk-form" id="mobileSignupForm">

            <div class="uk-margin">
                <div class="uk-width-1-1 uk-inline">
                    <span class="uk-form-icon" uk-icon="icon: user"></span>
                    <input class="uk-input uk-border-pill" placeholder="Full Name" id="signup_name" type="text" required="">
                </div>
            </div>

            <div class="uk-margin">
                <div class="uk-width-1-1 uk-inline">
                    <span class="uk-form-icon" uk-icon="icon: receiver"></span>
                    <input class="uk-input uk-border-pill" placeholder="Mobile Number" id="signup_mobile" type="tel" required="">
                    <small class="uk-text-muted">Format: +1234567890</small>
                </div>
            </div>

            <div class="uk-margin">
                <label>
                    <input class="uk-checkbox" type="checkbox" id="mobile_terms" required="">
                    I agree to the <a href="<?php echo $urlPath->terms(); ?>" target="_blank">Terms</a> and <a href="<?php echo $urlPath->privacy(); ?>" target="_blank">Privacy Policy</a>
                </label>
            </div>

            <div id="recaptcha-container-signup"></div>

            <button class="uk-button uk-width-1-1 uk-border-pill uk-button-primary uk-margin-small-top" type="submit" id="sendSignupOtpBtn">Send OTP</button>

        </form>
    </li>

</ul>

<!-- Social Signup Buttons -->
<?php if($settings['firebase_google_enabled'] == 1 || $settings['firebase_facebook_enabled'] == 1): ?>
<div class="uk-margin-medium-top">
    <div class="uk-text-center uk-text-muted uk-margin">
        <span>Or sign up with</span>
    </div>
    
    <div class="social-login-buttons">
        <?php if($settings['firebase_google_enabled'] == 1): ?>
        <button class="uk-button uk-button-default uk-width-1-1 uk-border-pill uk-margin-small" id="googleSignupBtn">
            <span uk-icon="icon: google; ratio: 0.9"></span> Sign up with Google
        </button>
        <?php endif; ?>
        
        <?php if($settings['firebase_facebook_enabled'] == 1): ?>
        <button class="uk-button uk-button-default uk-width-1-1 uk-border-pill" id="facebookSignupBtn">
            <span uk-icon="icon: facebook; ratio: 0.9"></span> Sign up with Facebook
        </button>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>

<div class="uk-margin uk-width-1-1 uk-text-center">
    Already have an account? <a class="tas-link-primary uk-text-bold" href="<?php echo $urlPath->signin(); ?>"><?php echo echoOutput($translation['tr_150']); ?></a>
</div>

</div>

</div>

<script>
// Initialize Firebase Auth Handler
document.addEventListener('DOMContentLoaded', function() {
    if (typeof AuthHandler !== 'undefined') {
        window.authHandler = new AuthHandler();
    }
});
</script>
