# Font Files Location and Configuration

## Current Setup

### Font Files Location
All font files are stored locally on your server:
```
/assets/fonts/
├── tabler-icons.eot
├── tabler-icons.svg
├── tabler-icons.ttf
├── tabler-icons.woff
├── tabler-icons.woff2
├── ionicons.eot
├── ionicons.svg
├── ionicons.ttf
└── ionicons.woff
```

### CSS Files That Reference Fonts
The fonts are referenced in:
- `/assets/css/tabler-icons.css`
- `/assets/css/tabler-icons.min.css`

These CSS files use **relative paths**:
```css
@font-face {
  font-family: "tabler-icons";
  src: url("../fonts/tabler-icons.woff2") format("woff2"),
       url("../fonts/tabler-icons.woff") format("woff"),
       url("../fonts/tabler-icons.ttf") format("truetype");
}
```

### How Fonts Are Loaded

1. **CSS is loaded** in `views/includes/header-css.php`:
   ```php
   <link rel="stylesheet" href="<?php echo $urlPath->assets_css('tabler-icons.min.css'); ?>">
   ```

2. **CSS loads from**: `https://www.alonedeals.com/assets/css/tabler-icons.min.css`

3. **Fonts load from**: `https://www.alonedeals.com/assets/fonts/tabler-icons.*`

## Why You're Seeing CDN Errors

The errors show fonts trying to load from `https://assets.alonedeals.com` because:

1. **Browser Cache**: Your browser cached the old CDN CSS files
2. **CDN Still Active**: The CSS files might still be on the CDN

## Solution: Force Local Loading

### Step 1: Verify CDN is Disabled

Check `views/includes/header-css.php` line 8:
```php
$cdn_css_url = ''; // Must be EMPTY
```

### Step 2: Clear All Caches

1. **Browser Cache**:
   - Chrome: Ctrl+Shift+Delete → Clear all
   - Firefox: Ctrl+Shift+Delete → Clear all
   - Or use Incognito/Private mode

2. **Server Cache** (if using caching):
   ```bash
   # Clear PHP opcache
   php clear_server_cache.php
   ```

3. **CDN Cache** (if using Cloudflare or similar):
   - Go to CDN dashboard
   - Purge all cache

### Step 3: Hard Reload

After clearing cache:
- Windows: Ctrl+Shift+R
- Mac: Cmd+Shift+R

## Verify It's Working

1. Open Developer Tools (F12)
2. Go to Network tab
3. Reload page
4. Check CSS files - they should load from:
   - ✅ `https://www.alonedeals.com/assets/css/...`
   - ❌ NOT from `https://assets.alonedeals.com/...`

5. Check font files - they should load from:
   - ✅ `https://www.alonedeals.com/assets/fonts/...`
   - ❌ NOT from `https://assets.alonedeals.com/...`

## If Fonts Still Don't Load

### Option 1: Check File Permissions
```bash
chmod 644 assets/fonts/*
```

### Option 2: Check .htaccess
Make sure your main `.htaccess` doesn't block font files:
```apache
# Allow font files
<FilesMatch "\.(ttf|otf|eot|woff|woff2)$">
    <IfModule mod_headers.c>
        Header set Access-Control-Allow-Origin "*"
    </IfModule>
</FilesMatch>
```

### Option 3: Verify Files Exist
Access directly in browser:
- https://www.alonedeals.com/assets/fonts/tabler-icons.woff2
- https://www.alonedeals.com/assets/fonts/tabler-icons.woff
- https://www.alonedeals.com/assets/fonts/tabler-icons.ttf

If these URLs return 404, the files are missing or path is wrong.

## Summary

✅ **Fonts ARE on your local server**: `/assets/fonts/`
✅ **CSS is configured to load locally**: `$cdn_css_url = ''`
✅ **Relative paths are correct**: `../fonts/tabler-icons.*`

The CORS errors you're seeing are from **cached CDN files**. Clear all caches and the fonts will load from your local server without any CORS issues.
