<?php require 'sidebar.php'; ?>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <h5><i class="fas fa-file-export"></i> Import / Export</h5>
        </div>

        <?php if (isset($_SESSION['import_success'])): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo $_SESSION['import_success']; unset($_SESSION['import_success']); ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php endif; ?>
        
        <?php if (isset($_SESSION['import_errors'])): ?>
        <div class="alert alert-warning alert-dismissible fade show" role="alert">
            <?php echo $_SESSION['import_errors']; unset($_SESSION['import_errors']); ?>
            <button type="button" class="close" data-dismiss="alert">&times;</button>
        </div>
        <?php endif; ?>

        <div class="row">

          <!-- Statistics Card -->
          <div class="col-12 mb-4">
            <div class="block">
              <div class="row">
                <div class="col-md-6">
                  <h6><i class="fa fa-chart-bar"></i> Statistics</h6>
                  <p><strong>Total Coupons:</strong> <?php echo number_format($total_coupons); ?></p>
                  <p><strong>Total Stores:</strong> <?php echo number_format($total_stores); ?></p>
                </div>
                <div class="col-md-6 text-right">
                  <a href="?action=export_coupons" class="btn btn-success mr-2">
                    <i class="fa fa-download"></i> Export Coupons
                  </a>
                  <a href="?action=export_stores" class="btn btn-success">
                    <i class="fa fa-download"></i> Export Stores
                  </a>
                </div>
              </div>
            </div>
          </div>

          <!-- Import Coupons -->
          <div class="col-md-6">
            <div class="block mb-4">
              <h6><i class="fa fa-upload"></i> Import Coupons</h6>
              <p class="text-muted">Upload a CSV file to import coupons. Stores will be auto-created if they don't exist.</p>
              
              <form method="post" action="?action=import_coupons" enctype="multipart/form-data">
                
                <div class="form-group">
                  <label>CSV File</label>
                  <input type="file" name="csv_file" class="form-control-file" accept=".csv" required>
                  <small class="form-text text-muted">
                    <strong>Format:</strong> Title, Merchant, Description, Coupon Code, URL, Start Date, End Date
                  </small>
                </div>
                
                <button type="submit" class="btn btn-primary">
                  <i class="fa fa-upload"></i> Import Coupons
                </button>
                
                <div class="alert alert-info mt-3">
                  <strong>Import Notes:</strong>
                  <ul class="mb-0">
                    <li>Stores will be automatically created if they don't exist</li>
                    <li>Date format: DD-MM-YYYY (e.g., 20-05-2025)</li>
                    <li>Duplicate coupons will be skipped</li>
                  </ul>
                </div>
                
              </form>
            </div>
          </div>

          <!-- Import Stores -->
          <div class="col-md-6">
            <div class="block mb-4">
              <h6><i class="fa fa-store"></i> Import Stores</h6>
              <p class="text-muted">Upload a CSV file to import stores.</p>
              
              <form method="post" action="?action=import_stores" enctype="multipart/form-data">
                
                <div class="form-group">
                  <label>CSV File</label>
                  <input type="file" name="csv_file" class="form-control-file" accept=".csv" required>
                  <small class="form-text text-muted">
                    <strong>Format:</strong> Store Name, Description, Slug, Featured, Status
                  </small>
                </div>
                
                <button type="submit" class="btn btn-primary">
                  <i class="fa fa-upload"></i> Import Stores
                </button>
                
                <div class="alert alert-info mt-3">
                  <strong>Import Notes:</strong>
                  <ul class="mb-0">
                    <li>Slug will be auto-generated if empty</li>
                    <li>Featured: 0 or 1</li>
                    <li>Status: 0 (inactive) or 1 (active)</li>
                    <li>Duplicate stores will be skipped</li>
                  </ul>
                </div>
                
              </form>
            </div>
          </div>

          <!-- Upload Store Image -->
          <div class="col-md-6">
            <div class="block mb-4">
              <h6><i class="fa fa-image"></i> Upload Store Image</h6>
              <p class="text-muted">Upload store logo/image via URL with live preview.</p>
              
              <form method="post" action="?action=upload_store_image">
                
                <div class="form-group">
                  <label>Select Store</label>
                  <select name="store_id" class="custom-select form-control" required>
                    <option value="">-- Select Store --</option>
                    <?php
                    $stores = $conn->query("SELECT store_id, store_title FROM stores ORDER BY store_title ASC");
                    while($store = $stores->fetch(PDO::FETCH_ASSOC)) {
                        echo '<option value="'.$store['store_id'].'">'.$store['store_title'].'</option>';
                    }
                    ?>
                  </select>
                </div>
                
                <div class="form-group">
                  <label>Image URL</label>
                  <input type="url" name="image_url" id="imageUrl" class="form-control" placeholder="https://example.com/logo.png" required>
                  <small class="form-text text-muted">Enter the direct URL to the store logo/image</small>
                </div>
                
                <div class="form-group">
                  <label>Preview</label>
                  <div id="imagePreview" style="min-height: 100px; padding: 20px; background: #f5f5f5; border-radius: 4px; text-align: center;">
                    <p class="text-muted mb-0">Enter image URL to see preview</p>
                  </div>
                </div>
                
                <button type="submit" class="btn btn-primary">
                  <i class="fa fa-check"></i> Upload Image
                </button>
                
              </form>
            </div>
          </div>

          <!-- CSV Template -->
          <div class="col-md-6">
            <div class="block mb-4">
              <h6><i class="fa fa-file-alt"></i> Sample CSV Template</h6>
              <p class="text-muted">Use this format for your CSV file:</p>
              
              <div style="background: #f8f9fa; padding: 15px; border-radius: 4px; overflow-x: auto;">
                <pre style="margin: 0; font-size: 12px;">Title,Merchant,Description,Coupon Code,URL,Start Date,End Date
"Get Flat Rs. 1000 Discount",Acwo,"Save Rs. 1000",ULTRA1000,https://example.com/,20-05-2025,31-12-2025
"50% Off on Party Wear",Mufti,"Get 50% discount",,https://example.com/,20-05-2025,31-12-2025</pre>
              </div>
              
              <div class="alert alert-secondary mt-3 mb-0">
                <strong>Export Format:</strong>
                <p class="mb-1"><strong>Coupons CSV:</strong> Title, Merchant, Description, Coupon Code, URL, Start Date, End Date</p>
                <p class="mb-0"><strong>Stores CSV:</strong> Store Name, Description, Slug, Featured, Status</p>
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>

<script>
// Image Preview
document.getElementById('imageUrl').addEventListener('input', function() {
    const url = this.value;
    const preview = document.getElementById('imagePreview');
    
    if (url && isValidImageUrl(url)) {
        preview.innerHTML = '<img src="' + url + '" alt="Preview" style="max-width: 200px; max-height: 200px; border-radius: 8px;">';
    } else {
        preview.innerHTML = '<p class="text-muted mb-0">Enter valid image URL to see preview</p>';
    }
});

function isValidImageUrl(url) {
    return url.match(/\.(jpeg|jpg|gif|png|webp|svg)$/i) != null || url.includes('image');
}
</script>
