<?php require 'sidebar.php'; ?>

<section class="page-container">
  <div class="page-content-wrapper">
    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">
        
        <div class="section-title">
          <h5>Create New Popup</h5>
        </div>

        <div class="row">
          <div class="col-lg-8">
            <div class="card">
              <div class="card-body">
                
                <?php if(!empty($errors)): ?>
                <div class="alert alert-danger">
                  <ul class="mb-0">
                    <?php foreach($errors as $error): ?>
                    <li><?php echo $error; ?></li>
                    <?php endforeach; ?>
                  </ul>
                </div>
                <?php endif; ?>

                <form method="post" enctype="multipart/form-data">
                  
                  <div class="form-group">
                    <label>Popup Title *</label>
                    <input type="text" name="popup_title" class="form-control" required>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Popup Type *</label>
                        <select name="popup_type" class="form-control" required>
                          <option value="offer">Offer Popup</option>
                          <option value="newsletter">Newsletter Popup</option>
                          <option value="footer">Footer Popup</option>
                          <option value="custom">Custom Popup</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Position</label>
                        <select name="popup_position" class="form-control">
                          <option value="center">Center</option>
                          <option value="bottom-right">Bottom Right</option>
                          <option value="bottom-left">Bottom Left</option>
                          <option value="top-right">Top Right</option>
                          <option value="top-left">Top Left</option>
                        </select>
                      </div>
                    </div>
                  </div>

                  <div class="form-group">
                    <label>Popup Content</label>
                    <textarea name="popup_content" class="form-control" rows="5" 
                              placeholder="HTML content for the popup"></textarea>
                    <small class="text-muted">You can use HTML tags</small>
                  </div>

                  <div class="form-group">
                    <label>Popup Image</label>
                    <input type="file" name="popup_image" class="form-control" accept="image/*">
                    <small class="text-muted">Optional: Upload an image for the popup</small>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Button Text</label>
                        <input type="text" name="popup_button_text" class="form-control" 
                               value="Get Offer" placeholder="Get Offer">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Button Link</label>
                        <input type="text" name="popup_button_link" class="form-control" 
                               placeholder="/stores">
                      </div>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Delay (milliseconds)</label>
                        <input type="number" name="popup_delay" class="form-control" 
                               value="3000" min="0">
                        <small class="text-muted">0 = immediate</small>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Frequency</label>
                        <select name="popup_frequency" class="form-control">
                          <option value="once">Once per user</option>
                          <option value="daily">Once per day</option>
                          <option value="session">Once per session</option>
                          <option value="always">Every page load</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-4">
                      <div class="form-group">
                        <label>Width</label>
                        <input type="text" name="popup_width" class="form-control" 
                               value="600px" placeholder="600px">
                      </div>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Show on Pages</label>
                        <select name="popup_show_on_pages" class="form-control">
                          <option value="all">All Pages</option>
                          <option value="home">Home Page Only</option>
                          <option value="stores">Stores Page Only</option>
                          <option value="coupons">Coupons Page Only</option>
                          <option value="single">Single Pages Only</option>
                        </select>
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Device Targeting</label>
                        <select name="popup_device" class="form-control">
                          <option value="both">Both (Mobile & Desktop)</option>
                          <option value="mobile">Mobile Only</option>
                          <option value="desktop">Desktop Only</option>
                        </select>
                        <small class="text-muted">Choose which devices should see this popup</small>
                      </div>
                    </div>
                  </div>

                  <div class="row">
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>Start Date (Optional)</label>
                        <input type="datetime-local" name="popup_start_date" class="form-control">
                      </div>
                    </div>
                    <div class="col-md-6">
                      <div class="form-group">
                        <label>End Date (Optional)</label>
                        <input type="datetime-local" name="popup_end_date" class="form-control">
                      </div>
                    </div>
                  </div>

                  <div class="form-group">
                    <label>Priority (Higher = Shows First)</label>
                    <input type="number" name="popup_priority" class="form-control" 
                           value="0" min="0">
                  </div>

                  <div class="form-group">
                    <div class="custom-control custom-checkbox">
                      <input type="checkbox" class="custom-control-input" 
                             id="popup_enabled" name="popup_enabled" checked>
                      <label class="custom-control-label" for="popup_enabled">
                        Enable this popup
                      </label>
                    </div>
                  </div>

                  <div class="form-group">
                    <button type="submit" class="btn btn-primary">
                      <i class="fa fa-save"></i> Create Popup
                    </button>
                    <a href="./popups.php" class="btn btn-secondary">Cancel</a>
                  </div>

                </form>

              </div>
            </div>
          </div>

          <div class="col-lg-4">
            <div class="card">
              <div class="card-header">
                <h6>Popup Types</h6>
              </div>
              <div class="card-body">
                <p><strong>Offer Popup:</strong> Show special offers and promotions</p>
                <p><strong>Newsletter:</strong> Collect email subscriptions</p>
                <p><strong>Footer Popup:</strong> Small popup at bottom corner</p>
                <p><strong>Custom:</strong> Any custom content</p>
              </div>
            </div>

            <div class="card mt-3">
              <div class="card-header">
                <h6>Tips</h6>
              </div>
              <div class="card-body">
                <ul class="mb-0">
                  <li>Use HTML in content for formatting</li>
                  <li>Set delay to 0 for immediate display</li>
                  <li>Higher priority popups show first</li>
                  <li>Use date range for limited campaigns</li>
                </ul>
              </div>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>
