<?php require 'sidebar.php'; ?>  

<script type="text/javascript">
  $(document).ready(function(){
    $('#table_id').dataTable({
     "bProcessing": true,
     "sAjaxSource": "../controller/get_products.php",
     "responsive": true,
     "bPaginate":true,
     "aaSorting": [[0,'desc']],
     "sPaginationType":"full_numbers",
     "iDisplayLength": 10,
     "aoColumns": [
     { mData: 'product_id', "width": "4%", "className": "text-center" },
     { "mData": null , "width": "10%", "className": "product text-center",
     "mRender" : function (data) {
      if(data.product_image){
        return "<img src='"+IMAGES_FOLDER+data.product_image+"' class='product-img product-img-horizontal'/>";
      }else if(data.product_image_cdn_url && data.product_use_cdn == 1){
        return "<img src='"+data.product_image_cdn_url+"' class='product-img product-img-horizontal'/>";
      }else{
        return "<img src='../assets/images/no-image.png' class='product-img product-img-horizontal'/>";
      }
    }
    },
    { mData: 'product_title', "width": "20%" },
    { "mData": null, "width": "12%",
     "mRender" : function (data) {
      if (data.store_title) {
        return '<span class="badge badge-primary" style="font-size: 11px; padding: 6px 10px;">' + data.store_title + '</span>';
      } else {
        return '<span class="text-muted" style="font-size: 11px;">No store</span>';
      }
     }
    },
    { "mData": null, "width": "10%", "className": "text-center",
     "mRender" : function (data) {
      if (data.product_original_price && data.product_sale_price) {
        return '<div><span style="text-decoration: line-through; color: #999;">₹' + data.product_original_price + '</span><br><strong style="color: #00a650;">₹' + data.product_sale_price + '</strong></div>';
      } else if (data.product_sale_price) {
        return '<strong style="color: #00a650;">₹' + data.product_sale_price + '</strong>';
      } else {
        return '<span class="text-muted">-</span>';
      }
     }
    },
    { "mData": null, "width": "8%", "className": "text-center",
     "mRender" : function (data) {
      if (data.product_discount_percentage) {
        return '<span class="badge badge-danger">' + data.product_discount_percentage + '% OFF</span>';
      } else {
        return '<span class="text-muted">-</span>';
      }
     }
    },
    { "mData": null , "width": "6%", "className":"status text-center",
     "mRender" : function (data) {
      if (data.product_featured == 1) {
        return '<span class="badge badge-pill bg-success"><i class="dripicons-checkmark"></i></span>';
      }else{
        return '<span class="badge badge-pill bg-warning"><i class="dripicons-cross"></i></span>';
        }
      }
    },
    { "mData": null , "width": "6%", "className":"status text-center",
     "mRender" : function (data) {
      if (data.product_status == 1) {
        return '<span class="label badge-pill bg-success"><?php echo _ENABLED; ?></span>';
      }else{
        return '<span class="label badge-pill bg-danger"><?php echo _DISABLED; ?></span>';
      }
      }
    },
    { "mData": null ,
    "width": "12%",
    "className": "text-center",
    'orderable': false,
    'searchable': false,
    "mRender" : function (data) {
      return "<a class='btn btn-small btn-primary' href='../controller/edit_product.php?id="+data.product_id+"'>"+EDITITEM+"</a> <a class='btn btn-small btn-danger btn-delete deleteItem' data-url='../controller/delete_product.php?id="+data.product_id+"'>"+DELETEITEM+"</a>";}
    }
    ]
  });
  });
</script>

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <h5 class="text-truncate"><i class="ti ti-shopping-bag"></i> Products</h5>
        </div>

        <div class="row">

          <div class="col-12 c-col-12">
            <a class="btn btn-primary" href="../controller/new_product.php">
              <i class="fa fa-plus add-new-i"></i> <?php echo _ADDITEM; ?>
            </a>
          </div>

          <div class="col-12">
            <div class="block table-block mb-4 c-4">

              <div class="row">
                <div class="table-responsive">
                  <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%" style="border-radius: 5px;">
                    <thead>
                      <tr>
                        <th><?php echo _TABLEFIELDID; ?></th>
                        <th><?php echo _TABLEFIELDIMAGE; ?></th>
                        <th><?php echo _TABLEFIELDTITLE; ?></th>
                        <th>Store</th>
                        <th>Price</th>
                        <th>Discount</th>
                        <th><?php echo _TABLEFIELDFEATURED; ?></th>
                        <th><?php echo _TABLEFIELDSTATUS; ?></th>
                        <th><?php echo _TABLEFIELDACTIONS; ?></th>
                      </tr>
                    </thead>
                  </table>

                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
