<?php require 'sidebar.php'; ?>  

<!--Page Container-->
<section class="page-container">
  <div class="page-content-wrapper">

    <!--Main Content-->

    <div class="content sm-gutter">
      <div class="container-fluid padding-25 sm-padding-10">

        <div class="section-title">
          <h5 class="text-truncate"><?php echo _STORES; ?></h5>
        </div>

        <div class="row">

          <div class="col-12 c-col-12" style="display: flex; align-items: center; margin-bottom: 20px;">
            <a class="btn btn-primary" href="../controller/new_store.php">
              <i class="fa fa-plus add-new-i"></i> <?php echo _ADDITEM; ?>
            </a>
            <button class="btn btn-success" data-toggle="modal" data-target="#importExportModal" style="margin-left: 10px;">
              <i class="ti ti-file-import"></i> Import / Export
            </button>
          </div>

          <!-- Table View Only -->
          <div class="col-12">
            <div class="block table-block mb-4 c-4">
              <div class="row">
                <div class="table-responsive">
                  <table id="table_id" class="table table-striped table-bordered" cellspacing="0" width="100%" style="border-radius: 5px;">
                    <thead>
                      <tr>
                        <th><?php echo _TABLEFIELDID; ?></th>
                        <th><?php echo _TABLEFIELDIMAGE; ?></th>
                        <th><?php echo _TABLEFIELDTITLE; ?></th>
                        <th>Categories</th>
                        <th><?php echo _TABLEFIELDFEATURED; ?></th>
                        <th><?php echo _TABLEFIELDSTATUS; ?></th>
                        <th><?php echo _TABLEFIELDACTIONS; ?></th>
                      </tr>
                    </thead>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


<!-- Import/Export Modal -->
<div class="modal fade" id="importExportModal" tabindex="-1" role="dialog" aria-labelledby="importExportModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="importExportModalLabel"><i class="ti ti-file-import"></i> Import / Export Stores</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
          <div class="col-md-6">
            <div class="card">
              <div class="card-body">
                <h5 class="card-title"><i class="ti ti-download"></i> Export Stores</h5>
                <p class="card-text">Download all stores as CSV file.</p>
                <a href="../controller/import_export.php?action=export_stores" class="btn btn-primary">
                  <i class="ti ti-download"></i> Export Stores CSV
                </a>
              </div>
            </div>
          </div>
          <div class="col-md-6">
            <div class="card">
              <div class="card-body">
                <h5 class="card-title"><i class="ti ti-upload"></i> Import Stores</h5>
                <p class="card-text">Upload CSV file to import stores.</p>
                <form method="post" action="../controller/import_export.php?action=import_stores" enctype="multipart/form-data">
                  <div class="form-group">
                    <input type="file" name="csv_file" class="form-control-file" accept=".csv" required>
                  </div>
                  <button type="submit" class="btn btn-primary">
                    <i class="ti ti-upload"></i> Import Stores
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
$(document).ready(function(){
  $('#table_id').dataTable({
   "bProcessing": true,
   "sAjaxSource": "../controller/get_stores.php",
   "responsive": true,
   "bPaginate":true,
   "sPaginationType":"full_numbers",
   "iDisplayLength": 10,
   "aoColumns": [
   { mData: 'store_id', "width": "5%", "className": "text-center" },
   { "mData": null , "width": "10%", "className": "product text-center",
   "mRender" : function (data) {
    return "<img src='"+IMAGES_FOLDER+data.store_image+"' class='product-img product-img-vertical'/>";}
  },
  { mData: 'store_title', "width": "20%" },
  { "mData": null, "width": "20%",
   "mRender" : function (data) {
    if (data.categories && data.categories.trim() !== '') {
      const cats = data.categories.split(' | ');
      let badges = '';
      cats.forEach(function(cat) {
        badges += '<span class="badge badge-info" style="margin: 2px; font-size: 11px; white-space: nowrap;">' + cat + '</span> ';
      });
      return badges;
    } else {
      return '<span class="text-muted" style="font-size: 11px;">No categories</span>';
    }
   }
  },
  { "mData": null , "width": "8%", "className":"status text-center",
   "mRender" : function (data) {
    if (data.store_featured == 1) {
      return '<span class="badge badge-pill bg-success"><i class="dripicons-checkmark"></i></span>';
    }else{
      return '<span class="badge badge-pill bg-warning"><i class="dripicons-cross"></i></span>';
      }
    }
  },
  { "mData": null , "width": "8%", "className":"status text-center",
   "mRender" : function (data) {
    if (data.store_status == 1) {
      return '<span class="badge badge-pill bg-success"><i class="dripicons-checkmark"></i></span>';
    }else{
      return '<span class="badge badge-pill bg-danger"><i class="dripicons-cross"></i></span>';
      }
    }
  },
  { "mData": null ,
  "width": "14%",
  "className": "text-center",
  'orderable': false,
  'searchable': false,
  "mRender" : function (data) {
    return "<a class='btn btn-small btn-primary' href='../controller/edit_store.php?id="+data.store_id+"'>"+EDITITEM+"</a> <a class='btn btn-small btn-danger btn-delete deleteItem' data-url='../controller/delete_store.php?id="+data.store_id+"'>"+DELETEITEM+"</a>";}
  }
  ]
});
});
</script>

