// Sticky Header for Mobile
(function() {
    'use strict';
    
    // Only run on mobile devices
    function isMobile() {
        return window.innerWidth <= 640;
    }
    
    function handleScroll() {
        if (!isMobile()) return;
        
        const navbar = document.querySelector('.tas_nav.uk-navbar-container');
        const body = document.body;
        
        if (!navbar) return;
        
        // Add sticky class when scrolled down more than 50px
        if (window.scrollY > 50) {
            navbar.classList.add('sticky');
            body.classList.add('sticky-active');
        } else {
            navbar.classList.remove('sticky');
            body.classList.remove('sticky-active');
        }
    }
    
    // Listen to scroll events
    window.addEventListener('scroll', handleScroll);
    
    // Listen to resize events to handle orientation changes
    window.addEventListener('resize', handleScroll);
    
    // Initial check
    handleScroll();
})();
