<?php
require "core.php";

try {
    // Pagination
    $itemsPerPage = 12;
    $currentPage = isset($_GET['page']) ? intval($_GET['page']) : 1;
    $offset = ($currentPage - 1) * $itemsPerPage;

    // Get category filter
    $categoryFilter = isset($_GET['category']) ? intval($_GET['category']) : 0;
    $categoryWhere = $categoryFilter > 0 ? "AND bp.post_category = $categoryFilter" : "";

    // Get total count
    $totalPosts = $connect->query("SELECT COUNT(*) FROM blog_posts bp WHERE bp.post_status = 'published' $categoryWhere")->fetchColumn();
    $totalPages = ceil($totalPosts / $itemsPerPage);

    // Get blog posts
    $query = "SELECT bp.*, bc.blog_cat_name, bc.blog_cat_slug, u.user_name 
              FROM blog_posts bp
              LEFT JOIN blog_categories bc ON bp.post_category = bc.blog_cat_id
              LEFT JOIN users u ON bp.post_author = u.user_id
              WHERE bp.post_status = 'published' $categoryWhere
              ORDER BY bp.published_at DESC
              LIMIT $itemsPerPage OFFSET $offset";

    $posts = $connect->query($query)->fetchAll(PDO::FETCH_ASSOC);

    // Get blog categories for sidebar
    $blogCategories = $connect->query("SELECT bc.*, COUNT(bp.post_id) as post_count 
                                       FROM blog_categories bc
                                       LEFT JOIN blog_posts bp ON bc.blog_cat_id = bp.post_category AND bp.post_status = 'published'
                                       WHERE bc.blog_cat_status = 1
                                       GROUP BY bc.blog_cat_id
                                       ORDER BY bc.blog_cat_name")->fetchAll(PDO::FETCH_ASSOC);

    // Get featured posts
    $featuredPosts = $connect->query("SELECT bp.*, bc.blog_cat_name 
                                      FROM blog_posts bp
                                      LEFT JOIN blog_categories bc ON bp.post_category = bc.blog_cat_id
                                      WHERE bp.post_status = 'published' AND bp.post_featured = 1
                                      ORDER BY bp.published_at DESC
                                      LIMIT 3")->fetchAll(PDO::FETCH_ASSOC);

    // SEO
    $titleSeoHeader = getSeoTitle($translation['tr_1'], "Blog - Latest News & Articles");
    $descriptionSeoHeader = getSeoDescription($translation['tr_3'], "Read the latest tech news, shopping tips, and deal alerts on our blog.");
    $canonicalUrl = SITE_URL . '/Post';
    $pageTitle = "Blog";
    
    // Set itemDetails for ad views
    $itemDetails = [
        'page_ad_header' => 1,
        'page_ad_footer' => 1,
        'page_footer' => 1
    ];

} catch (Exception $e) {
    header('Location: '. $urlPath->home());
    exit;
}

include './header.php';
include './sections/header.php';
include './sections/views/header-ad.view.php';
include './views/blog.view.php';
include './sections/views/footer-ad.view.php';
include './sections/footer.php';
include './footer.php';
?>
