<?php
require "core.php";

// Get the first published post
$stmt = $connect->query("SELECT post_id, post_title, post_slug, post_content, post_excerpt, LENGTH(post_content) as content_length 
                         FROM blog_posts 
                         WHERE post_status = 'published' 
                         LIMIT 1");
$post = $stmt->fetch(PDO::FETCH_ASSOC);

echo "<h2>Blog Post Debug</h2>";
echo "<p><strong>Post ID:</strong> " . $post['post_id'] . "</p>";
echo "<p><strong>Title:</strong> " . htmlspecialchars($post['post_title']) . "</p>";
echo "<p><strong>Slug:</strong> " . $post['post_slug'] . "</p>";
echo "<p><strong>Content Length:</strong> " . $post['content_length'] . " characters</p>";
echo "<hr>";
echo "<h3>Raw Content:</h3>";
echo "<pre>" . htmlspecialchars($post['post_content']) . "</pre>";
echo "<hr>";
echo "<h3>Rendered Content:</h3>";
echo "<div style='border: 1px solid #ccc; padding: 20px;'>";
echo $post['post_content'];
echo "</div>";
?>
