<div class="uk-container uk-margin-large-top uk-margin-large-bottom">
    <div class="uk-grid-medium" uk-grid>
        <!-- Main Content -->
        <div class="uk-width-expand@m">
            <article class="uk-article">
                
                <!-- Post Meta -->
                <div class="uk-article-meta uk-margin-bottom uk-flex uk-flex-middle uk-flex-wrap">
                    <?php if($post['blog_cat_name']): ?>
                    <span class="uk-label uk-margin-small-right" style="background: #667eea;">
                        <?php echo htmlspecialchars($post['blog_cat_name']); ?>
                    </span>
                    <?php endif; ?>
                    <span class="uk-text-muted uk-margin-small-right">
                        <i class="ti ti-calendar"></i> <?php echo date('F d, Y', strtotime($post['created_at'])); ?>
                    </span>
                    <span class="uk-text-muted uk-margin-small-right">
                        <i class="ti ti-user"></i> 
                        <a href="<?php echo SITE_URL; ?>/author/<?php echo $post['post_author']; ?>" style="color: #667eea;">
                            <?php echo htmlspecialchars($post['user_name'] ?: 'Admin'); ?>
                        </a>
                    </span>
                    <span class="uk-text-muted">
                        <i class="ti ti-eye"></i> <?php echo number_format($post['post_views']); ?> views
                    </span>
                </div>

                <!-- Post Title -->
                <h1 class="uk-article-title" style="font-size: 42px; line-height: 1.2; margin-bottom: 30px;">
                    <?php echo htmlspecialchars($post['post_title']); ?>
                </h1>

                <!-- Featured Image -->
                <?php if($post['post_featured_image']): ?>
                <div class="uk-margin-large-bottom" style="border-radius: 12px; overflow: hidden; box-shadow: 0 5px 20px rgba(0,0,0,0.1);">
                    <img src="<?php echo $post['post_use_cdn'] && $post['post_featured_image_cdn_url'] ? $post['post_featured_image_cdn_url'] : SITE_URL . '/images/' . $post['post_featured_image']; ?>" 
                         alt="<?php echo htmlspecialchars($post['post_title']); ?>"
                         style="width: 100%; height: auto; display: block;">
                </div>
                <?php endif; ?>

                <!-- Post Content -->
                <div class="uk-article-content" style="font-size: 18px; line-height: 1.8; color: #333;">
                    <?php 
                    if (!empty($post['post_content'])) {
                        echo $post['post_content']; 
                    } else {
                        echo '<div class="uk-alert uk-alert-warning"><p><strong>DEBUG:</strong> Post content is empty in database.</p><p>Post ID: ' . $post['post_id'] . '</p></div>';
                    }
                    ?>
                </div>

                <!-- Tags -->
                <?php if($post['post_tags']): ?>
                <div class="uk-margin-large-top uk-padding uk-background-muted" style="border-radius: 8px;">
                    <strong><i class="ti ti-tags"></i> Tags:</strong>
                    <?php 
                    $tags = explode(',', $post['post_tags']);
                    foreach($tags as $tag): 
                        $tag = trim($tag);
                    ?>
                    <span class="uk-label uk-margin-small-left" style="background: #667eea;"><?php echo htmlspecialchars($tag); ?></span>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <!-- Share Buttons -->
                <div class="uk-margin-large-top uk-card uk-card-default uk-card-body" style="border-radius: 12px; background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);">
                    <h4 style="margin-bottom: 15px;"><i class="ti ti-share"></i> Share this post</h4>
                    <div class="uk-grid-small uk-child-width-auto" uk-grid>
                        <div>
                            <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode(SITE_URL . '/Post/' . $post['post_slug']); ?>" 
                               target="_blank" class="uk-button uk-button-primary uk-border-rounded">
                                <i class="ti ti-brand-facebook"></i> Facebook
                            </a>
                        </div>
                        <div>
                            <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode(SITE_URL . '/Post/' . $post['post_slug']); ?>&text=<?php echo urlencode($post['post_title']); ?>" 
                               target="_blank" class="uk-button uk-border-rounded" style="background: #1da1f2; color: white;">
                                <i class="ti ti-brand-twitter"></i> Twitter
                            </a>
                        </div>
                        <div>
                            <a href="https://www.linkedin.com/shareArticle?mini=true&url=<?php echo urlencode(SITE_URL . '/Post/' . $post['post_slug']); ?>" 
                               target="_blank" class="uk-button uk-border-rounded" style="background: #0077b5; color: white;">
                                <i class="ti ti-brand-linkedin"></i> LinkedIn
                            </a>
                        </div>
                        <div>
                            <a href="https://wa.me/?text=<?php echo urlencode($post['post_title'] . ' ' . SITE_URL . '/Post/' . $post['post_slug']); ?>" 
                               target="_blank" class="uk-button uk-button-success uk-border-rounded">
                                <i class="ti ti-brand-whatsapp"></i> WhatsApp
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Related Posts -->
                <?php if(!empty($relatedPosts)): ?>
                <div class="uk-margin-large-top">
                    <h3 class="uk-heading-line"><span>Related Posts</span></h3>
                    <div class="uk-grid uk-grid-small uk-child-width-1-3@s" uk-grid>
                        <?php foreach($relatedPosts as $related): ?>
                        <div>
                            <div class="uk-card uk-card-default uk-card-hover" style="border-radius: 12px; overflow: hidden;">
                                <?php if($related['post_featured_image']): ?>
                                <div class="uk-card-media-top">
                                    <a href="<?php echo SITE_URL; ?>/Post/<?php echo $related['post_slug']; ?>">
                                        <img src="<?php echo getImageUrl($related['post_featured_image_cdn_url'], $related['post_use_cdn'], $related['post_featured_image']); ?>" 
                                             alt="<?php echo htmlspecialchars($related['post_title']); ?>"
                                             style="width: 100%; height: 150px; object-fit: cover;">
                                    </a>
                                </div>
                                <?php endif; ?>
                                <div class="uk-card-body">
                                    <h5 class="uk-card-title uk-margin-remove" style="font-size: 14px;">
                                        <a href="<?php echo SITE_URL; ?>/Post/<?php echo $related['post_slug']; ?>" class="uk-link-reset">
                                            <?php echo htmlspecialchars($related['post_title']); ?>
                                        </a>
                                    </h5>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                </div>
                <?php endif; ?>
            </article>
        </div>

        <!-- Sidebar -->
        <div class="uk-width-1-4@m">
            <!-- Author Box -->
            <div class="uk-card uk-card-default uk-card-body uk-margin-bottom" style="border-radius: 12px; text-align: center;">
                <div class="uk-cover-container uk-border-circle uk-margin-auto" style="width: 80px; height: 80px;">
                    <img src="<?php echo SITE_URL; ?>/images/<?php echo $post['user_avatar'] ?? 'default-avatar.png'; ?>" 
                         alt="<?php echo htmlspecialchars($post['user_name'] ?: 'Admin'); ?>" 
                         uk-cover>
                    <canvas width="80" height="80"></canvas>
                </div>
                <h4 class="uk-margin-small-top uk-margin-remove-bottom">
                    <a href="<?php echo SITE_URL; ?>/author/<?php echo $post['post_author']; ?>" class="uk-link-reset">
                        <?php echo htmlspecialchars($post['user_name'] ?: 'Admin'); ?>
                    </a>
                </h4>
                <p class="uk-text-small uk-text-muted uk-margin-small-top">
                    <?php echo nl2br(htmlspecialchars($post['user_bio'] ?: 'Content writer at Alonedeals.')); ?>
                </p>
                
                <!-- Social Media Links -->
                <?php if(!empty($post['user_facebook']) || !empty($post['user_twitter']) || !empty($post['user_instagram']) || !empty($post['user_linkedin']) || !empty($post['user_website'])): ?>
                <div class="uk-margin-small-top">
                    <?php if(!empty($post['user_facebook'])): ?>
                    <a href="<?php echo htmlspecialchars($post['user_facebook']); ?>" target="_blank" class="uk-icon-button" style="background: #3b5998;" uk-icon="facebook"></a>
                    <?php endif; ?>
                    <?php if(!empty($post['user_twitter'])): ?>
                    <a href="<?php echo htmlspecialchars($post['user_twitter']); ?>" target="_blank" class="uk-icon-button" style="background: #1da1f2;" uk-icon="twitter"></a>
                    <?php endif; ?>
                    <?php if(!empty($post['user_instagram'])): ?>
                    <a href="<?php echo htmlspecialchars($post['user_instagram']); ?>" target="_blank" class="uk-icon-button" style="background: #e1306c;" uk-icon="instagram"></a>
                    <?php endif; ?>
                    <?php if(!empty($post['user_linkedin'])): ?>
                    <a href="<?php echo htmlspecialchars($post['user_linkedin']); ?>" target="_blank" class="uk-icon-button" style="background: #0077b5;" uk-icon="linkedin"></a>
                    <?php endif; ?>
                    <?php if(!empty($post['user_website'])): ?>
                    <a href="<?php echo htmlspecialchars($post['user_website']); ?>" target="_blank" class="uk-icon-button" style="background: #666;" uk-icon="world"></a>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <a href="<?php echo SITE_URL; ?>/author/<?php echo $post['post_author']; ?>" class="uk-button uk-button-text uk-text-primary uk-margin-small-top">
                    View all posts <i class="ti ti-arrow-right"></i>
                </a>
            </div>

            <!-- Back to Blog -->
            <a href="<?php echo SITE_URL; ?>/Post" class="uk-button uk-button-default uk-width-1-1 uk-border-rounded">
                <i class="ti ti-arrow-left"></i> Back to Blog
            </a>
        </div>
    </div>
</div>

<style>
.uk-article-content h2 {
    font-size: 32px;
    margin-top: 40px;
    margin-bottom: 20px;
    color: #333;
}
.uk-article-content h3 {
    font-size: 26px;
    margin-top: 30px;
    margin-bottom: 15px;
    color: #444;
}
.uk-article-content p {
    margin-bottom: 20px;
}
.uk-article-content img {
    max-width: 100%;
    height: auto;
    border-radius: 8px;
    margin: 25px 0;
}
.uk-article-content ul, .uk-article-content ol {
    margin: 20px 0;
    padding-left: 30px;
}
.uk-article-content blockquote {
    border-left: 4px solid #667eea;
    padding-left: 20px;
    margin: 25px 0;
    font-style: italic;
    color: #666;
    background: #f5f7fa;
    padding: 20px;
    border-radius: 8px;
}
.uk-article-content a {
    color: #667eea;
    text-decoration: underline;
}
.uk-article-content a:hover {
    color: #764ba2;
}
</style>
